/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl;

import hudson.Extension;
import java.io.IOException;
import java.util.List;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceObserver;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Restricted(value={NoExternalUse.class})
public class SingleSCMNavigator
extends SCMNavigator {
    private final String name;
    private final List<SCMSource> sources;

    @DataBoundConstructor
    public SingleSCMNavigator(String name, List<SCMSource> sources) {
        this.name = name;
        this.sources = sources;
    }

    public String getName() {
        return this.name;
    }

    public List<SCMSource> getSources() {
        return this.sources;
    }

    @Override
    public void visitSources(SCMSourceObserver observer) throws IOException, InterruptedException {
        SCMSourceObserver.ProjectObserver projectObserver = observer.observe(this.name);
        for (SCMSource source : this.sources) {
            projectObserver.addSource(source);
        }
        projectObserver.complete();
    }

    @Extension
    public static class DescriptorImpl
    extends SCMNavigatorDescriptor {
        public String getDisplayName() {
            return "Single Repository";
        }

        public SCMNavigator newInstance(String name) {
            return null;
        }
    }
}

