/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;

public abstract class SCMHeadObserver {
    public abstract void observe(@NonNull SCMHead var1, @NonNull SCMRevision var2);

    public boolean isObserving() {
        return true;
    }

    @NonNull
    public static AllFinished allOf(SCMHeadObserver ... observers) {
        return new AllFinished(observers);
    }

    @NonNull
    public static OneFinished first(SCMHeadObserver ... observers) {
        return new OneFinished(observers);
    }

    @NonNull
    public static Collector collect() {
        return new Collector();
    }

    @NonNull
    public static Selector select(@NonNull SCMHead head) {
        return new Selector(head);
    }

    public static class Selector
    extends SCMHeadObserver {
        @NonNull
        private final SCMHead head;
        @CheckForNull
        private SCMRevision revision;

        public Selector(@NonNull SCMHead head) {
            head.getClass();
            this.head = head;
        }

        @CheckForNull
        public SCMRevision result() {
            return this.revision;
        }

        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            if (this.head.equals(head)) {
                this.revision = revision;
            }
        }

        public boolean isObserving() {
            return this.revision == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Collector
    extends SCMHeadObserver {
        @NonNull
        private final Map<SCMHead, SCMRevision> result = new TreeMap<SCMHead, SCMRevision>();

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            this.result.put(head, revision);
        }

        @NonNull
        public Map<SCMHead, SCMRevision> result() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OneFinished
    extends SCMHeadObserver {
        @NonNull
        private final Iterable<SCMHeadObserver> observers;

        public OneFinished(SCMHeadObserver ... observers) {
            this(Arrays.asList(observers));
        }

        public OneFinished(@NonNull Iterable<SCMHeadObserver> observers) {
            observers.getClass();
            this.observers = observers;
        }

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            for (SCMHeadObserver observer : this.observers) {
                observer.observe(head, revision);
            }
        }

        @Override
        public boolean isObserving() {
            for (SCMHeadObserver observer : this.observers) {
                if (observer.isObserving()) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllFinished
    extends SCMHeadObserver {
        @NonNull
        private final Iterable<SCMHeadObserver> observers;

        public AllFinished(SCMHeadObserver ... observers) {
            this(Arrays.asList(observers));
        }

        public AllFinished(@NonNull Iterable<SCMHeadObserver> observers) {
            observers.getClass();
            this.observers = observers;
        }

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            for (SCMHeadObserver observer : this.observers) {
                observer.observe(head, revision);
            }
        }

        @Override
        public boolean isObserving() {
            for (SCMHeadObserver observer : this.observers) {
                if (!observer.isObserving()) continue;
                return true;
            }
            return false;
        }
    }
}

