/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.model.User;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.LastGrantedAuthoritiesProperty;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jenkinsci.plugins.saml.SamlAuthenticationToken;
import org.jenkinsci.plugins.saml.SamlGroupAuthority;
import org.jenkinsci.plugins.saml.SamlUserDetails;

public class SamlUserDetailsService
implements UserDetailsService {
    public SamlUserDetails loadUserByUsername(@Nonnull String username) {
        LastGrantedAuthoritiesProperty lastGranted;
        Authentication auth = Jenkins.getAuthentication();
        if (username.compareTo(auth.getName()) == 0 && auth instanceof SamlAuthenticationToken) {
            return (SamlUserDetails)auth.getDetails();
        }
        User user = User.get((String)username, (boolean)false, Collections.emptyMap());
        if (user == null) {
            throw new UsernameNotFoundException(username);
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        if (username.compareTo(user.getId()) == 0 && (lastGranted = (LastGrantedAuthoritiesProperty)user.getProperty(LastGrantedAuthoritiesProperty.class)) != null) {
            for (GrantedAuthority a : lastGranted.getAuthorities()) {
                if (a == SecurityRealm.AUTHENTICATED_AUTHORITY) continue;
                SamlGroupAuthority ga = new SamlGroupAuthority(a.getAuthority());
                authorities.add(ga);
            }
        }
        return new SamlUserDetails(user.getId(), authorities.toArray(new GrantedAuthority[0]));
    }
}

