/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.pac4j.core.exception.TechnicalException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

class SamlFileResource
implements WritableResource {
    private static final Logger LOG = Logger.getLogger(SamlFileResource.class.getName());
    private String fileName;
    private byte[] data;

    public SamlFileResource(@Nonnull String fileName) {
        this.fileName = fileName;
    }

    public SamlFileResource(@Nonnull String fileName, @Nonnull String data) {
        this.fileName = fileName;
        try {
            this.data = data.getBytes("UTF-8");
            FileUtils.writeByteArrayToFile((File)this.getFile(), (byte[])this.data);
        }
        catch (UnsupportedEncodingException e) {
            throw new TechnicalException("Could not get string bytes.", (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Could not save the " + fileName + " file.", (Throwable)e);
        }
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public boolean isReadable() {
        return this.getFile().canRead();
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() {
        throw new NotImplementedException();
    }

    public URI getURI() {
        throw new NotImplementedException();
    }

    public String getFilename() {
        return this.fileName;
    }

    public String getDescription() {
        return this.fileName;
    }

    public InputStream getInputStream() throws IOException {
        return FileUtils.openInputStream((File)this.getFile());
    }

    public File getFile() {
        return new File(this.fileName);
    }

    public long contentLength() {
        return this.getFile().length();
    }

    public long lastModified() {
        return this.getFile().lastModified();
    }

    public Resource createRelative(String s) {
        throw new NotImplementedException();
    }

    public boolean isWritable() {
        return this.getFile().canWrite();
    }

    public OutputStream getOutputStream() throws IOException {
        return FileUtils.openOutputStream((File)this.getFile());
    }
}

