/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.saml.SamlFormValidation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SamlAdvancedConfiguration
extends AbstractDescribableImpl<SamlAdvancedConfiguration> {
    private final Boolean forceAuthn;
    private final String authnContextClassRef;
    private final String spEntityId;
    private final String nameIdPolicyFormat;
    @Deprecated
    private Integer maximumSessionLifetime;

    @DataBoundConstructor
    public SamlAdvancedConfiguration(Boolean forceAuthn, String authnContextClassRef, String spEntityId, String nameIdPolicyFormat, Integer maximumSessionLifetime) {
        this.forceAuthn = forceAuthn != null ? forceAuthn : false;
        this.authnContextClassRef = Util.fixEmptyAndTrim((String)authnContextClassRef);
        this.spEntityId = Util.fixEmptyAndTrim((String)spEntityId);
        this.nameIdPolicyFormat = Util.fixEmptyAndTrim((String)nameIdPolicyFormat);
    }

    public Boolean getForceAuthn() {
        return this.forceAuthn;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SamlAdvancedConfiguration{");
        sb.append("forceAuthn=").append(this.getForceAuthn());
        sb.append(", authnContextClassRef='").append(StringUtils.defaultIfBlank((String)this.getAuthnContextClassRef(), (String)"none")).append('\'');
        sb.append(", spEntityId='").append(StringUtils.defaultIfBlank((String)this.getSpEntityId(), (String)"none")).append('\'');
        sb.append(", nameIdPolicyFormat='").append(StringUtils.defaultIfBlank((String)this.getNameIdPolicyFormat(), (String)"none")).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SamlAdvancedConfiguration> {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SamlAdvancedConfiguration> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return "Advanced Configuration";
        }

        public FormValidation doCheckAuthnContextClassRef(@QueryParameter String authnContextClassRef) {
            return SamlFormValidation.checkStringFormat(authnContextClassRef);
        }

        public FormValidation doCheckSpEntityId(@QueryParameter String spEntityId) {
            return SamlFormValidation.checkStringFormat(spEntityId);
        }

        public FormValidation doCheckNameIdPolicyFormat(@QueryParameter String nameIdPolicyFormat) {
            return SamlFormValidation.checkStringFormat(nameIdPolicyFormat);
        }

        public FormValidation doCheckMaximumSessionLifetime(@QueryParameter String maximumSessionLifetime) {
            if (StringUtils.isEmpty((String)maximumSessionLifetime)) {
                return FormValidation.ok();
            }
            long i = 0L;
            try {
                i = Long.parseLong(maximumSessionLifetime);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.", (Object[])new Object[]{e});
            }
            if (i < 0L) {
                return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.");
            }
            if (i > Integer.MAX_VALUE) {
                return FormValidation.error((String)"The field should be a number greater than 0 and lower than 2147483647.");
            }
            return FormValidation.ok();
        }
    }
}

