/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml.user;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class SamlCustomProperty
extends UserProperty {
    List<Attribute> attributes;

    @DataBoundConstructor
    public SamlCustomProperty(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @NonNull
    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyList();
        }
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        public String getDisplayName() {
            return "Saml Custom Attributes property";
        }

        public SamlCustomProperty newInstance(User user) {
            return new SamlCustomProperty(new ArrayList<Attribute>());
        }
    }

    public static class Attribute {
        private final String name;
        private final String displayName;
        private String value;

        public Attribute(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)o;
            return Objects.equals(this.name, attribute.name) && Objects.equals(this.displayName, attribute.displayName) && Objects.equals(this.value, attribute.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.displayName, this.value);
        }
    }
}

