/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.saml.SamlFormValidation;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;
import org.jenkinsci.plugins.saml.SamlValidateIdPMetadata;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class IdpMetadataConfiguration
extends AbstractDescribableImpl<IdpMetadataConfiguration> {
    private static final Logger LOG = Logger.getLogger(IdpMetadataConfiguration.class.getName());
    private String xml;
    private String url;
    private Long period;

    @DataBoundConstructor
    public IdpMetadataConfiguration(String xml, String url, Long period) {
        this.xml = xml;
        this.url = url;
        this.period = StringUtils.isBlank((String)url) || period == null ? Long.valueOf(0L) : period;
    }

    public IdpMetadataConfiguration(@Nonnull String xml) {
        this.xml = xml;
        this.period = 0L;
    }

    public IdpMetadataConfiguration(@Nonnull String url, @Nonnull Long period) {
        this.url = url;
        this.period = period;
    }

    public String getXml() {
        return this.xml;
    }

    public String getUrl() {
        return this.url;
    }

    public Long getPeriod() {
        return this.period;
    }

    public String getIdpMetadata() throws IOException {
        return FileUtils.readFileToString((File)new File(SamlSecurityRealm.getIDPMetadataFilePath()));
    }

    public void createIdPMetadataFile() throws IOException {
        try {
            if (StringUtils.isNotBlank((String)this.xml)) {
                FileUtils.writeStringToFile((File)new File(SamlSecurityRealm.getIDPMetadataFilePath()), (String)this.xml);
            } else {
                this.updateIdPMetadata();
            }
        }
        catch (IOException e) {
            throw new IOException("Can not write IdP metadata file in JENKINS_HOME", e);
        }
    }

    public void updateIdPMetadata() throws IOException {
        block9: {
            try {
                URLConnection urlConnection = ProxyConfiguration.open((URL)new URL(this.url));
                try (InputStream in = urlConnection.getInputStream();){
                    TransformerFactory tf = TransformerFactory.newInstance();
                    tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    Transformer transformer = tf.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "no");
                    transformer.setOutputProperty("indent", "yes");
                    StringWriter writer = new StringWriter();
                    transformer.transform(new StreamSource(in), new StreamResult(writer));
                    String idpXml = writer.toString();
                    FormValidation validation = (FormValidation)new SamlValidateIdPMetadata(idpXml).get();
                    if (FormValidation.Kind.OK == validation.kind) {
                        FileUtils.writeStringToFile((File)new File(SamlSecurityRealm.getIDPMetadataFilePath()), (String)idpXml);
                        break block9;
                    }
                    throw new IllegalArgumentException(validation.getMessage());
                }
            }
            catch (IOException | TransformerException e) {
                throw new IOException("Was not possible to update the IdP Metadata from the URL " + this.url, e);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IdpMetadataConfiguration{");
        sb.append("xml='").append(this.xml).append('\'');
        sb.append(", url='").append(this.url).append('\'');
        sb.append(", period=").append(this.period);
        sb.append('}');
        return sb.toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<IdpMetadataConfiguration> {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends IdpMetadataConfiguration> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return "";
        }

        public FormValidation doTestIdpMetadata(@QueryParameter(value="xml") String xml) {
            if (StringUtils.isBlank((String)xml)) {
                return FormValidation.error((String)"The IdP Metadata can not be empty.");
            }
            return (FormValidation)new SamlValidateIdPMetadata(xml).get();
        }

        public FormValidation doCheckPeriod(@QueryParameter(value="period") String period) {
            return SamlFormValidation.checkIntegerFormat(period);
        }

        public FormValidation doCheckXml(@QueryParameter(value="xml") String xml, @QueryParameter(value="url") String url) {
            if (StringUtils.isBlank((String)xml) && StringUtils.isBlank((String)url)) {
                return FormValidation.error((String)"The IdP Metadata can not be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@QueryParameter(value="url") String url) {
            if (StringUtils.isEmpty((String)url)) {
                return FormValidation.ok();
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"The url is malformed.", (Object[])new Object[]{e});
            }
            return FormValidation.ok();
        }

        public FormValidation doTestIdpMetadataURL(@QueryParameter(value="url") String url) {
            FormValidation formValidation;
            block11: {
                URLConnection urlConnection = null;
                try {
                    urlConnection = ProxyConfiguration.open((URL)new URL(url));
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                    return FormValidation.error((String)("Was not possible to get the Metadata from the URL" + url));
                }
                InputStream in = urlConnection.getInputStream();
                try {
                    String xml = IOUtils.toString((InputStream)in, (String)StringUtils.defaultIfEmpty((String)urlConnection.getContentEncoding(), (String)"UTF-8"));
                    formValidation = (FormValidation)new SamlValidateIdPMetadata(xml).get();
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (MalformedURLException e) {
                        return FormValidation.error((String)"The url is malformed.");
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                        return FormValidation.error((String)("Was not possible to get the Metadata from the URL" + url));
                    }
                }
                in.close();
            }
            return formValidation;
        }
    }
}

