/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.saml.IdpMetadataConfiguration;
import org.jenkinsci.plugins.saml.SamlAdvancedConfiguration;
import org.jenkinsci.plugins.saml.SamlAuthenticationToken;
import org.jenkinsci.plugins.saml.SamlEncryptionData;
import org.jenkinsci.plugins.saml.SamlGroupAuthority;
import org.jenkinsci.plugins.saml.SamlGroupDetails;
import org.jenkinsci.plugins.saml.SamlPluginConfig;
import org.jenkinsci.plugins.saml.SamlProfileWrapper;
import org.jenkinsci.plugins.saml.SamlRedirectActionWrapper;
import org.jenkinsci.plugins.saml.SamlSPMetadataWrapper;
import org.jenkinsci.plugins.saml.SamlUserDetails;
import org.jenkinsci.plugins.saml.SamlUserDetailsService;
import org.jenkinsci.plugins.saml.conf.Attribute;
import org.jenkinsci.plugins.saml.conf.AttributeEntry;
import org.jenkinsci.plugins.saml.user.SamlCustomProperty;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.saml.profile.SAML2Profile;
import org.springframework.dao.DataAccessException;

public class SamlSecurityRealm
extends SecurityRealm {
    public static final String DEFAULT_DISPLAY_NAME_ATTRIBUTE_NAME = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/name";
    public static final String DEFAULT_GROUPS_ATTRIBUTE_NAME = "http://schemas.xmlsoap.org/claims/Group";
    public static final int DEFAULT_MAXIMUM_AUTHENTICATION_LIFETIME = 86400;
    public static final String DEFAULT_USERNAME_CASE_CONVERSION = "none";
    public static final String SP_METADATA_FILE_NAME = "/saml-sp-metadata.xml";
    public static final String IDP_METADATA_FILE_NAME = "/saml-idp-metadata.xml";
    public static final String ERROR_ONLY_SPACES_FIELD_VALUE = "The field should have a value different than spaces";
    public static final String ERROR_NOT_VALID_NUMBER = "The field should be a number greater than 0 and lower than 2147483647.";
    public static final String ERROR_MALFORMED_URL = "The url is malformed.";
    public static final String ERROR_IDP_METADATA_EMPTY = "The IdP Metadata can not be empty.";
    public static final String WARN_RECOMMENDED_TO_SET_THE_GROUPS_ATTRIBUTE = "It is recommended to set the groups attribute.";
    public static final String WARN_RECOMMENDED_TO_SET_THE_USERNAME_ATTRIBUTE = "It is recommended to set the username attribute.";
    public static final String ERROR_NOT_POSSIBLE_TO_READ_KS_FILE = "It is not possible to read the keystore file.";
    public static final String ERROR_CERTIFICATES_COULD_NOT_BE_LOADED = "Any of the certificates in the keystore could not be loaded";
    public static final String ERROR_ALGORITHM_CANNOT_BE_FOUND = "the algorithm used to check the integrity of the keystore cannot be found";
    public static final String ERROR_NO_PROVIDER_SUPPORTS_A_KS_SPI_IMPL = "No Provider supports a KeyStoreSpi implementation for the specified type.";
    public static final String ERROR_WRONG_INFO_OR_PASSWORD = "The entry is a PrivateKeyEntry or SecretKeyEntry and the specified protParam does not contain the information needed to recover the key (e.g. wrong password)";
    public static final String ERROR_INSUFFICIENT_OR_INVALID_INFO = "The specified protParam were insufficient or invalid";
    public static final String CONSUMER_SERVICE_URL_PATH = "securityRealm/finishLogin";
    public static final String EXPIRATION_ATTRIBUTE = SamlSecurityRealm.class.getName() + ".expiration";
    private static final Logger LOG = Logger.getLogger(SamlSecurityRealm.class.getName());
    private static final String REFERER_ATTRIBUTE = SamlSecurityRealm.class.getName() + ".referer";
    public static final String WARN_THERE_IS_NOT_KEY_STORE = "There is not keyStore to validate";
    public static final String ERROR_NOT_KEY_FOUND = "Not key found";
    public static final String SUCCESS = "Success";
    public static final String NOT_POSSIBLE_TO_GET_THE_METADATA = "Was not possible to get the Metadata from the URL";
    private String displayNameAttributeName;
    private String groupsAttributeName;
    private int maximumAuthenticationLifetime;
    private String emailAttributeName;
    private final String usernameCaseConversion;
    private final String usernameAttributeName;
    private final String logoutUrl;
    private String binding;
    private SamlEncryptionData encryptionData;
    private SamlAdvancedConfiguration advancedConfiguration;
    @Deprecated
    private transient String idpMetadata;
    private IdpMetadataConfiguration idpMetadataConfiguration;
    private List<AttributeEntry> samlCustomAttributes;

    @DataBoundConstructor
    public SamlSecurityRealm(IdpMetadataConfiguration idpMetadataConfiguration, String displayNameAttributeName, String groupsAttributeName, Integer maximumAuthenticationLifetime, String usernameAttributeName, String emailAttributeName, String logoutUrl, SamlAdvancedConfiguration advancedConfiguration, SamlEncryptionData encryptionData, String usernameCaseConversion, String binding, List<AttributeEntry> samlCustomAttributes) throws IOException {
        this.idpMetadataConfiguration = idpMetadataConfiguration;
        this.usernameAttributeName = Util.fixEmptyAndTrim((String)usernameAttributeName);
        this.usernameCaseConversion = StringUtils.defaultIfBlank((String)usernameCaseConversion, (String)DEFAULT_USERNAME_CASE_CONVERSION);
        this.logoutUrl = Util.fixEmptyAndTrim((String)logoutUrl);
        this.displayNameAttributeName = DEFAULT_DISPLAY_NAME_ATTRIBUTE_NAME;
        this.groupsAttributeName = DEFAULT_GROUPS_ATTRIBUTE_NAME;
        this.maximumAuthenticationLifetime = 86400;
        if (displayNameAttributeName != null && !displayNameAttributeName.isEmpty()) {
            this.displayNameAttributeName = displayNameAttributeName;
        }
        if (groupsAttributeName != null && !groupsAttributeName.isEmpty()) {
            this.groupsAttributeName = groupsAttributeName;
        }
        if (maximumAuthenticationLifetime != null && maximumAuthenticationLifetime > 0) {
            this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
        }
        if (StringUtils.isNotBlank((String)emailAttributeName)) {
            this.emailAttributeName = Util.fixEmptyAndTrim((String)emailAttributeName);
        }
        this.advancedConfiguration = advancedConfiguration;
        this.encryptionData = encryptionData;
        this.binding = binding;
        this.samlCustomAttributes = samlCustomAttributes;
        this.idpMetadataConfiguration.createIdPMetadataFile();
        LOG.finer(this.toString());
    }

    public Object readResolve() {
        File idpMetadataFile;
        if (this.idpMetadataConfiguration == null) {
            this.idpMetadataConfiguration = new IdpMetadataConfiguration(this.idpMetadata);
        }
        if (!(idpMetadataFile = new File(SamlSecurityRealm.getIDPMetadataFilePath())).exists() && this.idpMetadataConfiguration != null && this.idpMetadataConfiguration.getXml() != null) {
            try {
                this.idpMetadataConfiguration.createIdPMetadataFile();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (StringUtils.isEmpty((String)this.getBinding())) {
            this.binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
        }
        return this;
    }

    public boolean allowsSignup() {
        return false;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        LOG.finer("createSecurityComponents");
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof SamlAuthenticationToken) {
                    return authentication;
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        }, (UserDetailsService)new SamlUserDetailsService());
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    public HttpResponse doCommenceLogin(StaplerRequest request, StaplerResponse response, @Header(value="Referer") String referer) {
        LOG.fine("SamlSecurityRealm.doCommenceLogin called. Using consumerServiceUrl " + this.getSamlPluginConfig().getConsumerServiceUrl());
        request.getSession().setAttribute(REFERER_ATTRIBUTE, (Object)referer);
        RedirectAction action = (RedirectAction)new SamlRedirectActionWrapper(this.getSamlPluginConfig(), request, response).get();
        if (action.getType() == RedirectAction.RedirectType.REDIRECT) {
            LOG.fine("REDIRECT : " + action.getLocation());
            return HttpResponses.redirectTo((String)action.getLocation());
        }
        if (action.getType() == RedirectAction.RedirectType.SUCCESS) {
            LOG.fine("SUCCESS : " + action.getContent());
            return HttpResponses.html((String)action.getContent());
        }
        throw new IllegalStateException("Received unexpected response type " + action.getType());
    }

    @RequirePOST
    public HttpResponse doFinishLogin(StaplerRequest request, StaplerResponse response) {
        LOG.finer("SamlSecurityRealm.doFinishLogin called");
        this.logSamlResponse(request);
        boolean saveUser = false;
        SAML2Profile saml2Profile = (SAML2Profile)new SamlProfileWrapper(this.getSamlPluginConfig(), request, response).get();
        String username = this.loadUserName(saml2Profile);
        List<GrantedAuthority> authorities = this.loadGrantedAuthorities(saml2Profile);
        SamlUserDetails userDetails = new SamlUserDetails(username, authorities.toArray(new GrantedAuthority[authorities.size()]));
        if (this.getAdvancedConfiguration() != null && this.getAdvancedConfiguration().getMaximumSessionLifetime() != null) {
            request.getSession().setAttribute(EXPIRATION_ATTRIBUTE, (Object)(System.currentTimeMillis() + (long)(1000 * this.getAdvancedConfiguration().getMaximumSessionLifetime())));
        }
        SamlAuthenticationToken samlAuthToken = new SamlAuthenticationToken(userDetails, request.getSession());
        SecurityContextHolder.getContext().setAuthentication((Authentication)samlAuthToken);
        SecurityListener.fireAuthenticated((UserDetails)userDetails);
        User user = User.current();
        saveUser |= this.modifyUserFullName(user, saml2Profile);
        saveUser |= this.modifyUserEmail(user, (List)saml2Profile.getAttribute(this.getEmailAttributeName()));
        saveUser |= this.modifyUserSamlCustomAttributes(user, saml2Profile);
        try {
            if (user != null && saveUser) {
                user.save();
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to save updated user data", e);
        }
        SecurityListener.fireLoggedIn((String)userDetails.getUsername());
        String referer = (String)request.getSession().getAttribute(REFERER_ATTRIBUTE);
        String redirectUrl = referer != null ? referer : this.baseUrl();
        return HttpResponses.redirectTo((String)redirectUrl);
    }

    private boolean modifyUserSamlCustomAttributes(User user, SAML2Profile profile) {
        boolean saveUser = false;
        if (!this.getSamlCustomAttributes().isEmpty() && user != null) {
            SamlCustomProperty userProperty = new SamlCustomProperty(new ArrayList<SamlCustomProperty.Attribute>());
            for (AttributeEntry attributeEntry : this.getSamlCustomAttributes()) {
                if (!(attributeEntry instanceof Attribute)) continue;
                Attribute attr = (Attribute)attributeEntry;
                SamlCustomProperty.Attribute item = new SamlCustomProperty.Attribute(attr.getName(), attr.getDisplayName());
                item.setValue(profile.getAttribute(attr.getName()).toString());
                userProperty.getAttributes().add(item);
            }
            try {
                user.addProperty((UserProperty)userProperty);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Could not update user SAML custom attributes", e);
            }
            saveUser = true;
        }
        return saveUser;
    }

    private void logSamlResponse(StaplerRequest request) {
        if (LOG.isLoggable(Level.FINEST)) {
            try {
                String samlResponse = request.getParameter("SAMLResponse");
                if (Base64.isBase64((String)samlResponse)) {
                    LOG.finest("SAMLResponse XML:" + new String(Base64.decodeBase64((String)samlResponse), request.getCharacterEncoding()));
                } else {
                    LOG.finest("SAMLResponse XML:" + samlResponse);
                }
            }
            catch (Exception e) {
                LOG.finest("No UTF-8 SAMLResponse XML");
                try (ServletInputStream in = request.getInputStream();){
                    LOG.finest(IOUtils.toString((InputStream)in, (String)request.getCharacterEncoding()));
                }
                catch (IOException e1) {
                    LOG.finest("Was not possible to read the request");
                }
            }
        }
    }

    private String baseUrl() {
        return Jenkins.getInstance().getRootUrl();
    }

    private String loadUserName(SAML2Profile saml2Profile) {
        String username = this.getUsernameFromProfile(saml2Profile);
        if ("lowercase".compareTo(this.getUsernameCaseConversion()) == 0) {
            username = username.toLowerCase();
        } else if ("uppercase".compareTo(this.getUsernameCaseConversion()) == 0) {
            username = username.toUpperCase();
        }
        return username;
    }

    private boolean modifyUserFullName(User user, SAML2Profile saml2Profile) {
        boolean saveUser = false;
        String userFullName = null;
        List names = (List)saml2Profile.getAttribute(this.getDisplayNameAttributeName());
        if (names != null && !names.isEmpty()) {
            userFullName = (String)names.get(0);
        }
        if (user != null && StringUtils.isNotBlank(userFullName) && userFullName.compareTo(user.getFullName()) != 0) {
            user.setFullName(userFullName);
            saveUser = true;
        }
        return saveUser;
    }

    private List<GrantedAuthority> loadGrantedAuthorities(SAML2Profile saml2Profile) {
        ArrayList groups = (ArrayList)saml2Profile.getAttribute(this.getGroupsAttributeName());
        if (groups == null) {
            groups = new ArrayList();
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add(AUTHENTICATED_AUTHORITY);
        if (!groups.isEmpty()) {
            for (Object group : groups) {
                SamlGroupAuthority ga = new SamlGroupAuthority((String)group);
                authorities.add(ga);
            }
        }
        return authorities;
    }

    private boolean modifyUserEmail(User user, List<String> emails) {
        String userEmail = null;
        boolean saveUser = false;
        if (emails == null || emails.isEmpty()) {
            LOG.warning("There is not Email attribute '" + this.getEmailAttributeName() + "' for user : " + user.getId());
            return saveUser;
        }
        for (String item : emails) {
            if (!StringUtils.isNotEmpty((String)item)) continue;
            userEmail = item;
            break;
        }
        if (StringUtils.isBlank(userEmail)) {
            LOG.warning("The Email is blank for user : " + user.getId());
        }
        try {
            Mailer.UserProperty currentUserEmailProperty;
            if (user != null && StringUtils.isNotBlank(userEmail) && ((currentUserEmailProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)) == null || userEmail.compareTo(StringUtils.defaultIfBlank((String)currentUserEmailProperty.getAddress(), (String)"")) != 0)) {
                Mailer.UserProperty emailProperty = new Mailer.UserProperty(userEmail);
                user.addProperty((UserProperty)emailProperty);
                saveUser = true;
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not update user email", e);
        }
        return saveUser;
    }

    private String getUsernameFromProfile(SAML2Profile saml2Profile) {
        if (this.getUsernameAttributeName() != null) {
            Object attribute = saml2Profile.getAttribute(this.getUsernameAttributeName());
            if (attribute instanceof String) {
                return (String)attribute;
            }
            if (attribute instanceof List) {
                return (String)((List)attribute).get(0);
            }
            LOG.log(Level.SEVERE, "Unable to get username from attribute {0} value {1}, Saml Profile {2}", new Object[]{this.getUsernameAttributeName(), attribute, saml2Profile});
            LOG.log(Level.SEVERE, "Falling back to NameId {0}", saml2Profile.getId());
        }
        return saml2Profile.getId();
    }

    static String getIDPMetadataFilePath() {
        return Jenkins.getInstance().getRootDir().getAbsolutePath() + IDP_METADATA_FILE_NAME;
    }

    static String getSPMetadataFilePath() {
        return Jenkins.getInstance().getRootDir().getAbsolutePath() + SP_METADATA_FILE_NAME;
    }

    public HttpResponse doMetadata(StaplerRequest request, StaplerResponse response) {
        return (HttpResponse)new SamlSPMetadataWrapper(this.getSamlPluginConfig(), request, response).get();
    }

    protected String getPostLogOutUrl(StaplerRequest req, @Nonnull Authentication auth) {
        LOG.log(Level.FINE, "Doing Logout {}", auth.getPrincipal());
        if (Jenkins.getInstance().hasPermission(Jenkins.READ) && StringUtils.isBlank((String)this.getLogoutUrl())) {
            return super.getPostLogOutUrl(req, auth);
        }
        return StringUtils.isNotBlank((String)this.getLogoutUrl()) ? this.getLogoutUrl() : Jenkins.getInstance().getRootUrl() + "samlLogout";
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        super.doLogout(req, rsp);
        LOG.log(Level.FINEST, "Here we could do the SAML Single Logout");
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        SamlGroupDetails dg = new SamlGroupDetails(groupname);
        if (dg.getMembers().isEmpty()) {
            throw new UserMayOrMayNotExistException(groupname);
        }
        return dg;
    }

    public GroupDetails loadGroupByGroupname(String groupname, boolean fetchMembers) throws UsernameNotFoundException, DataAccessException {
        GroupDetails dg = this.loadGroupByGroupname(groupname);
        if (fetchMembers) {
            dg.getMembers();
        }
        return dg;
    }

    public SamlPluginConfig getSamlPluginConfig() {
        SamlPluginConfig samlPluginConfig = new SamlPluginConfig(this.displayNameAttributeName, this.groupsAttributeName, this.maximumAuthenticationLifetime, this.emailAttributeName, this.idpMetadataConfiguration, this.usernameCaseConversion, this.usernameAttributeName, this.logoutUrl, this.binding, this.encryptionData, this.advancedConfiguration);
        return samlPluginConfig;
    }

    public String getUsernameAttributeName() {
        return this.usernameAttributeName;
    }

    public String getDisplayNameAttributeName() {
        return this.displayNameAttributeName;
    }

    public String getGroupsAttributeName() {
        return this.groupsAttributeName;
    }

    public Integer getMaximumAuthenticationLifetime() {
        return this.maximumAuthenticationLifetime;
    }

    public SamlAdvancedConfiguration getAdvancedConfiguration() {
        return this.advancedConfiguration;
    }

    public String getBinding() {
        return this.binding;
    }

    public SamlEncryptionData getEncryptionData() {
        return this.encryptionData;
    }

    public String getUsernameCaseConversion() {
        return this.usernameCaseConversion;
    }

    public String getEmailAttributeName() {
        return this.emailAttributeName;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public IdpMetadataConfiguration getIdpMetadataConfiguration() {
        return this.idpMetadataConfiguration;
    }

    @NonNull
    public List<AttributeEntry> getSamlCustomAttributes() {
        if (this.samlCustomAttributes == null) {
            return Collections.emptyList();
        }
        return this.samlCustomAttributes;
    }

    public void setSamlCustomAttribute(List<AttributeEntry> samlCustomAttributes) {
        this.samlCustomAttributes = samlCustomAttributes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SamlSecurityRealm{");
        sb.append(this.getSamlPluginConfig().toString());
        sb.append('}');
        return sb.toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SecurityRealm> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return "SAML 2.0";
        }

        public FormValidation doCheckLogoutUrl(@QueryParameter String logoutUrl) {
            if (StringUtils.isEmpty((String)logoutUrl)) {
                return FormValidation.ok();
            }
            try {
                new URL(logoutUrl);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)SamlSecurityRealm.ERROR_MALFORMED_URL, (Object[])new Object[]{e});
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDisplayNameAttributeName(@QueryParameter String displayNameAttributeName) {
            if (StringUtils.isEmpty((String)displayNameAttributeName)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)displayNameAttributeName)) {
                return FormValidation.error((String)SamlSecurityRealm.ERROR_ONLY_SPACES_FIELD_VALUE);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGroupsAttributeName(@QueryParameter String groupsAttributeName) {
            if (StringUtils.isEmpty((String)groupsAttributeName)) {
                return FormValidation.warning((String)SamlSecurityRealm.WARN_RECOMMENDED_TO_SET_THE_GROUPS_ATTRIBUTE);
            }
            if (StringUtils.isBlank((String)groupsAttributeName)) {
                return FormValidation.error((String)SamlSecurityRealm.ERROR_ONLY_SPACES_FIELD_VALUE);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUsernameAttributeName(@QueryParameter String usernameAttributeName) {
            if (StringUtils.isEmpty((String)usernameAttributeName)) {
                return FormValidation.warning((String)SamlSecurityRealm.WARN_RECOMMENDED_TO_SET_THE_USERNAME_ATTRIBUTE);
            }
            if (StringUtils.isBlank((String)usernameAttributeName)) {
                return FormValidation.error((String)SamlSecurityRealm.ERROR_ONLY_SPACES_FIELD_VALUE);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEmailAttributeName(@QueryParameter String emailAttributeName) {
            if (StringUtils.isEmpty((String)emailAttributeName)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)emailAttributeName)) {
                return FormValidation.error((String)SamlSecurityRealm.ERROR_ONLY_SPACES_FIELD_VALUE);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMaximumAuthenticationLifetime(@QueryParameter String maximumAuthenticationLifetime) {
            if (StringUtils.isEmpty((String)maximumAuthenticationLifetime)) {
                return FormValidation.ok();
            }
            long i = 0L;
            try {
                i = Long.parseLong(maximumAuthenticationLifetime);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)SamlSecurityRealm.ERROR_NOT_VALID_NUMBER, (Object[])new Object[]{e});
            }
            if (i < 0L) {
                return FormValidation.error((String)SamlSecurityRealm.ERROR_NOT_VALID_NUMBER);
            }
            if (i > Integer.MAX_VALUE) {
                return FormValidation.error((String)SamlSecurityRealm.ERROR_NOT_VALID_NUMBER);
            }
            return FormValidation.ok();
        }
    }
}

