/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import java.util.logging.Logger;
import org.acegisecurity.BadCredentialsException;
import org.jenkinsci.plugins.saml.OpenSAMLWrapper;
import org.jenkinsci.plugins.saml.SamlPluginConfig;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.SAML2Profile;

public class SamlProfileWrapper
extends OpenSAMLWrapper<SAML2Profile> {
    private static final Logger LOG = Logger.getLogger(SamlProfileWrapper.class.getName());

    public SamlProfileWrapper(SamlPluginConfig samlPluginConfig, StaplerRequest request, StaplerResponse response) {
        this.request = request;
        this.response = response;
        this.samlPluginConfig = samlPluginConfig;
    }

    @Override
    protected SAML2Profile process() {
        SAML2Profile saml2Profile;
        SAML2Credentials credentials;
        try {
            SAML2Client client = this.createSAML2Client();
            WebContext context = this.createWebContext();
            credentials = (SAML2Credentials)client.getCredentials(context);
            saml2Profile = (SAML2Profile)client.getUserProfile((Credentials)credentials, context);
        }
        catch (HttpAction | SAMLException e) {
            throw new BadCredentialsException(e.getMessage(), e);
        }
        if (saml2Profile == null) {
            String msg = "Could not find user profile for SAML credentials: " + credentials;
            LOG.severe(msg);
            throw new BadCredentialsException(msg);
        }
        LOG.finer(saml2Profile.toString());
        return saml2Profile;
    }
}

