/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.Util;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.saml.IdpMetadataConfiguration;
import org.jenkinsci.plugins.saml.SamlAdvancedConfiguration;
import org.jenkinsci.plugins.saml.SamlEncryptionData;

public class SamlPluginConfig {
    private String displayNameAttributeName;
    private String groupsAttributeName;
    private int maximumAuthenticationLifetime;
    private String emailAttributeName;
    private final IdpMetadataConfiguration idpMetadataConfiguration;
    private final String usernameCaseConversion;
    private final String usernameAttributeName;
    private final String logoutUrl;
    private final String binding;
    private SamlEncryptionData encryptionData;
    private SamlAdvancedConfiguration advancedConfiguration;

    public SamlPluginConfig(String displayNameAttributeName, String groupsAttributeName, int maximumAuthenticationLifetime, String emailAttributeName, IdpMetadataConfiguration idpMetadataConfiguration, String usernameCaseConversion, String usernameAttributeName, String logoutUrl, String binding, SamlEncryptionData encryptionData, SamlAdvancedConfiguration advancedConfiguration) {
        this.displayNameAttributeName = displayNameAttributeName;
        this.groupsAttributeName = groupsAttributeName;
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
        this.emailAttributeName = emailAttributeName;
        this.idpMetadataConfiguration = idpMetadataConfiguration;
        this.usernameCaseConversion = StringUtils.defaultIfBlank((String)usernameCaseConversion, (String)"none");
        this.usernameAttributeName = Util.fixEmptyAndTrim((String)usernameAttributeName);
        this.logoutUrl = logoutUrl;
        this.binding = binding;
        this.encryptionData = encryptionData;
        this.advancedConfiguration = advancedConfiguration;
    }

    public String getUsernameAttributeName() {
        return this.usernameAttributeName;
    }

    public String getDisplayNameAttributeName() {
        return this.displayNameAttributeName;
    }

    public String getGroupsAttributeName() {
        return this.groupsAttributeName;
    }

    public Integer getMaximumAuthenticationLifetime() {
        return this.maximumAuthenticationLifetime;
    }

    public SamlAdvancedConfiguration getAdvancedConfiguration() {
        return this.advancedConfiguration;
    }

    public Boolean getForceAuthn() {
        return this.getAdvancedConfiguration() != null ? this.getAdvancedConfiguration().getForceAuthn() : Boolean.FALSE;
    }

    public String getAuthnContextClassRef() {
        return this.getAdvancedConfiguration() != null ? this.getAdvancedConfiguration().getAuthnContextClassRef() : null;
    }

    public String getSpEntityId() {
        return this.getAdvancedConfiguration() != null ? this.getAdvancedConfiguration().getSpEntityId() : null;
    }

    public SamlEncryptionData getEncryptionData() {
        return this.encryptionData;
    }

    public String getUsernameCaseConversion() {
        return this.usernameCaseConversion;
    }

    public String getEmailAttributeName() {
        return this.emailAttributeName;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getConsumerServiceUrl() {
        return this.baseUrl() + "securityRealm/finishLogin";
    }

    public String baseUrl() {
        return Jenkins.getInstance().getRootUrl();
    }

    public IdpMetadataConfiguration getIdpMetadataConfiguration() {
        return this.idpMetadataConfiguration;
    }

    public String getBinding() {
        return this.binding;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SamlPluginConfig{");
        sb.append("idpMetadataConfiguration='").append((Object)this.getIdpMetadataConfiguration()).append('\'');
        sb.append(", displayNameAttributeName='").append(this.getDisplayNameAttributeName()).append('\'');
        sb.append(", groupsAttributeName='").append(this.getGroupsAttributeName()).append('\'');
        sb.append(", emailAttributeName='").append(this.getEmailAttributeName()).append('\'');
        sb.append(", usernameAttributeName='").append(this.getUsernameAttributeName()).append('\'');
        sb.append(", maximumAuthenticationLifetime=").append(this.getMaximumAuthenticationLifetime());
        sb.append(", usernameCaseConversion='").append(this.getUsernameCaseConversion()).append('\'');
        sb.append(", logoutUrl='").append(this.getLogoutUrl()).append('\'');
        sb.append(", binding='").append(this.getBinding()).append('\'');
        sb.append(", encryptionData=").append((Object)this.getEncryptionData());
        sb.append(", advancedConfiguration=").append((Object)this.getAdvancedConfiguration());
        sb.append('}');
        return sb.toString();
    }
}

