/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.model.User;
import hudson.security.GroupDetails;
import java.util.HashSet;
import java.util.Set;
import jenkins.security.LastGrantedAuthoritiesProperty;
import org.acegisecurity.GrantedAuthority;

public class SamlGroupDetails
extends GroupDetails {
    private final String name;
    private final Set<String> members = new HashSet<String>();

    public SamlGroupDetails(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public Set<String> getMembers() {
        if (this.members.isEmpty()) {
            for (User u : User.getAll()) {
                LastGrantedAuthoritiesProperty prop = (LastGrantedAuthoritiesProperty)u.getProperty(LastGrantedAuthoritiesProperty.class);
                if (!this.hasGroupOnAuthorities(prop)) continue;
                this.members.add(u.getId());
            }
        }
        return this.members;
    }

    private boolean hasGroupOnAuthorities(LastGrantedAuthoritiesProperty prop) {
        if (prop != null) {
            for (GrantedAuthority a : prop.getAuthorities()) {
                if (!this.name.equals(a.getAuthority())) continue;
                return true;
            }
        }
        return false;
    }
}

