/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpSession;
import jenkins.security.SecurityListener;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;
import org.jenkinsci.plugins.saml.SamlUserDetails;

public final class SamlAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 2L;
    private final SamlUserDetails userDetails;
    private final transient HttpSession session;
    private final Long expiration;

    public SamlAuthenticationToken(@Nonnull SamlUserDetails userDetails, @Nonnull HttpSession session) {
        super(userDetails.getAuthorities());
        this.userDetails = userDetails;
        this.setDetails(userDetails);
        this.setAuthenticated(true);
        this.session = session;
        this.expiration = (Long)session.getAttribute(SamlSecurityRealm.EXPIRATION_ATTRIBUTE);
    }

    public SamlUserDetails getPrincipal() {
        if (this.expiration != null && System.currentTimeMillis() > this.expiration) {
            this.setAuthenticated(false);
            this.session.invalidate();
            SecurityContextHolder.clearContext();
            SecurityListener.fireLoggedOut((String)this.userDetails.getUsername());
        }
        return this.userDetails;
    }

    public String getCredentials() {
        return "SAML does not use passwords";
    }
}

