/*
 * Decompiled with CFR 0.152.
 */
package com.waytta.clientinterface;

import com.waytta.Utils;
import com.waytta.clientinterface.BasicClient;
import hudson.Extension;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class LocalSubsetClient
extends BasicClient {
    private static final long serialVersionUID = 1L;
    private String function;
    private String arguments;
    private String subset = "1";
    private String target;
    private String targettype;
    private transient String targetType;
    public static final BasicClient.BasicClientDescriptor DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public LocalSubsetClient(String function, String arguments, String subset, String target, String targettype) {
        this.function = function;
        this.arguments = arguments;
        this.subset = subset;
        this.target = target;
        this.targettype = targettype;
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public String getArguments() {
        return this.arguments;
    }

    @Override
    public String getSubset() {
        return this.subset;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public String getTargettype() {
        return this.targettype;
    }

    protected Object readResolve() throws IOException {
        if (this.targetType != null) {
            this.targettype = this.targetType;
        }
        return this;
    }

    @Symbol(value={"subset"})
    @Extension
    public static class DescriptorImpl
    extends BasicClient.BasicClientDescriptor {
        public DescriptorImpl() {
            super(LocalSubsetClient.class);
        }

        @Override
        public String getDisplayName() {
            return "local_subset";
        }

        public FormValidation doCheckFunction(@QueryParameter String value) {
            return Utils.validateFormStringField(value, "Please specify a salt function", "Isn't it too short?");
        }

        public FormValidation doCheckTarget(@QueryParameter String value) {
            return Utils.validateFormStringField(value, "Please specify a salt target", "Isn't it too short?");
        }

        public FormValidation doCheckSubset(@QueryParameter String value) {
            Pattern pattern = Pattern.compile("\\{\\{\\w+\\}\\}");
            Matcher matcher = pattern.matcher(value);
            if (matcher.matches()) {
                return FormValidation.ok();
            }
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Specify a number");
            }
            return FormValidation.ok();
        }
    }
}

