/*
 * Decompiled with CFR 0.152.
 */
package com.waytta.clientinterface;

import com.waytta.SaltAPIBuilder;
import com.waytta.Utils;
import com.waytta.clientinterface.BasicClient;
import hudson.Extension;
import hudson.util.FormValidation;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class LocalClient
extends BasicClient {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_JOB_POLL_TIME = 10;
    private int jobPollTime = 10;
    private int minionTimeout = 30;
    private boolean blockbuild = false;
    private String target;
    private String targettype;
    private transient String targetType;
    private String function;
    private String arguments;
    public static final BasicClient.BasicClientDescriptor DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public LocalClient(String function, String arguments, String target, String targettype) {
        this.function = function;
        this.arguments = arguments;
        this.target = target;
        this.targettype = targettype;
    }

    @Override
    public String getFunction() {
        return this.function;
    }

    @Override
    public String getArguments() {
        return this.arguments;
    }

    @Override
    public int getJobPollTime() {
        return this.jobPollTime;
    }

    @DataBoundSetter
    public void setJobPollTime(int jobPollTime) {
        this.jobPollTime = jobPollTime;
    }

    @Override
    public int getMinionTimeout() {
        return this.minionTimeout;
    }

    @DataBoundSetter
    public void setMinionTimeout(int minionTimeout) {
        this.minionTimeout = minionTimeout;
    }

    @Override
    public boolean getBlockbuild() {
        return this.blockbuild;
    }

    @DataBoundSetter
    public void setBlockbuild(boolean blockbuild) {
        this.blockbuild = blockbuild;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public String getTargettype() {
        return this.targettype;
    }

    protected Object readResolve() throws IOException {
        if (this.targetType != null) {
            this.targettype = this.targetType;
        }
        return this;
    }

    @Symbol(value={"local"})
    @Extension
    public static class DescriptorImpl
    extends BasicClient.BasicClientDescriptor {
        public DescriptorImpl() {
            super(LocalClient.class);
        }

        @Override
        public String getDisplayName() {
            return "local";
        }

        public FormValidation doCheckFunction(@QueryParameter String value) {
            return Utils.validateFormStringField(value, "Please specify a salt function", "Isn't it too short?");
        }

        public FormValidation doCheckTarget(@QueryParameter String value) {
            return Utils.validateFormStringField(value, "Please specify a salt target", "Isn't it too short?");
        }

        public int getJobPollTime() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                throw new IllegalStateException("Jenkins has not been started, or was already shut down");
            }
            SaltAPIBuilder.DescriptorImpl sabd = (SaltAPIBuilder.DescriptorImpl)jenkins.getDescriptor(SaltAPIBuilder.class);
            return sabd.getPollTime();
        }

        public int getMinionTimeout() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                throw new IllegalStateException("Jenkins has not been started, or was already shut down");
            }
            SaltAPIBuilder.DescriptorImpl sabd = (SaltAPIBuilder.DescriptorImpl)jenkins.getDescriptor(SaltAPIBuilder.class);
            return sabd.getMinionTimeout();
        }
    }
}

