/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Logger;

public final class Uploads {
    private static final Logger LOGGER = Logger.getLogger(Uploads.class.getName());
    private static final int MULTIPART_UPLOAD_THRESHOLD = 0x1000000;
    private static volatile transient Uploads instance;
    private final transient HashMap<FilePath, Upload> startedUploads = new HashMap();
    private final transient HashMap<FilePath, InputStream> openedStreams = new HashMap();

    private Uploads() {
    }

    public Upload startUploading(TransferManager manager, FilePath file, InputStream inputsStream, String bucketName, String objectName, ObjectMetadata metadata) throws AmazonServiceException {
        PutObjectRequest request = new PutObjectRequest(bucketName, objectName, inputsStream, metadata);
        request.getRequestClientOptions().setReadLimit(0x1000000);
        manager.getConfiguration().setMultipartUploadThreshold(0x1000000L);
        Upload upload = manager.upload(request);
        this.startedUploads.put(file, upload);
        this.openedStreams.put(file, inputsStream);
        return upload;
    }

    public void finishUploading(FilePath filePath) throws InterruptedException {
        Upload upload = this.startedUploads.remove(filePath);
        if (upload == null) {
            LOGGER.info("File: " + filePath.getName() + " already was uploaded");
            return;
        }
        try {
            upload.waitForCompletion();
        }
        finally {
            this.closeStream(filePath);
        }
    }

    public void cleanup(FilePath filePath) {
        this.startedUploads.remove(filePath);
        this.closeStream(filePath);
    }

    private void closeStream(FilePath filePath) {
        try {
            InputStream stream = this.openedStreams.remove(filePath);
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            LOGGER.warning("Failed to close stream for file:" + filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Uploads getInstance() {
        if (instance != null) return instance;
        Class<Uploads> clazz = Uploads.class;
        synchronized (Uploads.class) {
            if (instance != null) return instance;
            instance = new Uploads();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

