/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3.callable;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.transfer.TransferManager;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.plugins.s3.ClientHelper;
import hudson.util.Secret;
import java.util.HashMap;
import org.jenkinsci.remoting.RoleChecker;

abstract class S3Callable<T>
implements FilePath.FileCallable<T> {
    private static final long serialVersionUID = 1L;
    private final String accessKey;
    private final Secret secretKey;
    private final boolean useRole;
    private final String region;
    private final ProxyConfiguration proxy;
    private static transient HashMap<String, TransferManager> transferManagers = new HashMap();

    S3Callable(String accessKey, Secret secretKey, boolean useRole, String region, ProxyConfiguration proxy) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.useRole = useRole;
        this.region = region;
        this.proxy = proxy;
    }

    protected synchronized TransferManager getTransferManager() {
        String uniqueKey = this.getUniqueKey();
        if (transferManagers.get(uniqueKey) == null) {
            AmazonS3Client client = ClientHelper.createClient(this.accessKey, Secret.toString((Secret)this.secretKey), this.useRole, this.region, this.proxy);
            transferManagers.put(uniqueKey, new TransferManager((AmazonS3)client));
        }
        return transferManagers.get(uniqueKey);
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
    }

    private String getUniqueKey() {
        return this.region + '_' + this.secretKey + '_' + this.accessKey + '_' + this.useRole;
    }
}

