/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3.callable;

import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.model.ObjectMetadata;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.plugins.s3.Destination;
import hudson.plugins.s3.callable.S3Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public abstract class S3BaseUploadCallable
extends S3Callable<String> {
    private static final long serialVersionUID = 1L;
    private final Destination dest;
    private final String storageClass;
    private final Map<String, String> userMetadata;
    private final boolean useServerSideEncryption;

    public S3BaseUploadCallable(String accessKey, Secret secretKey, boolean useRole, Destination dest, Map<String, String> userMetadata, String storageClass, String selregion, boolean useServerSideEncryption, ProxyConfiguration proxy) {
        super(accessKey, secretKey, useRole, selregion, proxy);
        this.dest = dest;
        this.storageClass = storageClass;
        this.userMetadata = userMetadata;
        this.useServerSideEncryption = useServerSideEncryption;
    }

    public String invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
        return this.invoke(new FilePath(file));
    }

    public abstract String invoke(FilePath var1) throws IOException, InterruptedException;

    protected ObjectMetadata buildMetadata(FilePath filePath) throws IOException, InterruptedException {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(Mimetypes.getInstance().getMimetype(filePath.getName()));
        metadata.setContentLength(filePath.length());
        metadata.setLastModified(new Date(filePath.lastModified()));
        if (this.storageClass != null && !this.storageClass.isEmpty()) {
            metadata.setHeader("x-amz-storage-class", (Object)this.storageClass);
        }
        if (this.useServerSideEncryption) {
            metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        }
        block14: for (Map.Entry<String, String> entry : this.userMetadata.entrySet()) {
            String key;
            switch (key = entry.getKey().toLowerCase()) {
                case "cache-control": {
                    metadata.setCacheControl(entry.getValue());
                    continue block14;
                }
                case "expires": {
                    try {
                        Date expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").parse(entry.getValue());
                        metadata.setHttpExpiresDate(expires);
                    }
                    catch (ParseException e) {
                        metadata.addUserMetadata(entry.getKey(), entry.getValue());
                    }
                    continue block14;
                }
                case "content-encoding": {
                    metadata.setContentEncoding(entry.getValue());
                    continue block14;
                }
                case "content-type": {
                    metadata.setContentType(entry.getValue());
                    continue block14;
                }
            }
            metadata.addUserMetadata(entry.getKey(), entry.getValue());
        }
        return metadata;
    }

    public Destination getDest() {
        return this.dest;
    }
}

