/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import hudson.model.Run;
import hudson.plugins.s3.Destination;
import hudson.plugins.s3.FingerprintRecord;
import hudson.plugins.s3.S3BucketPublisher;
import hudson.plugins.s3.S3Profile;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class S3ArtifactsAction
implements RunAction2 {
    private final Run build;
    private final String profile;
    private final List<FingerprintRecord> artifacts;

    public S3ArtifactsAction(Run<?, ?> run, S3Profile profile, List<FingerprintRecord> artifacts) {
        this.build = run;
        this.profile = profile.getName();
        this.artifacts = artifacts;
        this.onLoad(run);
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public String getIconFileName() {
        return "fingerprint.png";
    }

    public String getDisplayName() {
        return "S3 Artifacts";
    }

    public String getUrlName() {
        return "s3";
    }

    public void onLoad(Run<?, ?> r) {
    }

    public void onAttached(Run r) {
    }

    public String getProfile() {
        return this.profile;
    }

    @Exported
    public List<FingerprintRecord> getArtifacts() {
        return this.artifacts;
    }

    public void doDownload(StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        String restOfPath = request.getRestOfPath();
        if (restOfPath == null) {
            return;
        }
        String artifact = restOfPath.substring(1);
        for (FingerprintRecord record : this.artifacts) {
            if (!record.getArtifact().getName().equals(artifact)) continue;
            S3Profile s3 = S3BucketPublisher.getProfile(this.profile);
            AmazonS3Client client = s3.getClient(record.getArtifact().getRegion());
            String url = this.getDownloadURL(client, s3.getSignedUrlExpirySeconds(), this.build, record);
            response.sendRedirect2(url);
            return;
        }
        response.sendError(404, "This artifact is not available");
    }

    private String getDownloadURL(AmazonS3Client client, int signedUrlExpirySeconds, Run run, FingerprintRecord record) {
        Destination dest = Destination.newFromRun(run, record.getArtifact());
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(dest.bucketName, dest.objectName);
        request.setExpiration(new Date(System.currentTimeMillis() + (long)(signedUrlExpirySeconds * 1000)));
        if (!record.isShowDirectlyInBrowser()) {
            ResponseHeaderOverrides headers = new ResponseHeaderOverrides();
            String fileName = new File(dest.objectName).getName().trim();
            headers.setContentDisposition("attachment; filename=\"" + fileName + '\"');
            request.setResponseHeaders(headers);
        }
        return client.generatePresignedUrl(request).toExternalForm();
    }
}

