/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.Region;
import hudson.ProxyConfiguration;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientHelper {
    public static final String DEFAULT_AMAZON_S3_REGION_NAME = System.getProperty("hudson.plugins.s3.DEFAULT_AMAZON_S3_REGION", Region.US_Standard.toAWSRegion().getName());

    public static AmazonS3Client createClient(String accessKey, String secretKey, boolean useRole, String region, ProxyConfiguration proxy) {
        com.amazonaws.regions.Region awsRegion = ClientHelper.getRegionFromString(region);
        ClientConfiguration clientConfiguration = ClientHelper.getClientConfiguration(proxy, awsRegion);
        AmazonS3Client client = useRole ? new AmazonS3Client(clientConfiguration) : new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey), clientConfiguration);
        client.setRegion(awsRegion);
        return client;
    }

    @Nonnull
    private static com.amazonaws.regions.Region getRegionFromString(@Nullable String regionName) {
        com.amazonaws.regions.Region region = null;
        if (regionName == null || regionName.isEmpty()) {
            region = RegionUtils.getRegion((String)DEFAULT_AMAZON_S3_REGION_NAME);
        }
        if (region == null) {
            region = RegionUtils.getRegion((String)regionName);
        }
        if (region == null) {
            region = RegionUtils.getRegion((String)Regions.valueOf((String)regionName).getName());
        }
        if (region == null) {
            region = RegionUtils.getRegion((String)DEFAULT_AMAZON_S3_REGION_NAME);
        }
        if (region == null) {
            throw new IllegalStateException("No AWS Region found for name '" + regionName + "' and default region '" + DEFAULT_AMAZON_S3_REGION_NAME + "'");
        }
        return region;
    }

    @Nonnull
    public static ClientConfiguration getClientConfiguration(@Nonnull ProxyConfiguration proxy, @Nonnull com.amazonaws.regions.Region region) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        String s3Endpoint = region.getServiceEndpoint("s3");
        if (ClientHelper.shouldUseProxy(proxy, s3Endpoint)) {
            clientConfiguration.setProxyHost(proxy.name);
            clientConfiguration.setProxyPort(proxy.port);
            if (proxy.getUserName() != null) {
                clientConfiguration.setProxyUsername(proxy.getUserName());
                clientConfiguration.setProxyPassword(proxy.getPassword());
            }
        }
        return clientConfiguration;
    }

    private static boolean shouldUseProxy(ProxyConfiguration proxy, String hostname) {
        if (proxy == null) {
            return false;
        }
        boolean shouldProxy = true;
        for (Pattern p : proxy.getNoProxyHostPatterns()) {
            if (!p.matcher(hostname).matches()) continue;
            shouldProxy = false;
            break;
        }
        return shouldProxy;
    }
}

