/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck.cache;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jenkinsci.plugins.rundeck.RundeckNotifier;
import org.jenkinsci.plugins.rundeck.cache.RundeckJobCache;
import org.jenkinsci.plugins.rundeck.cache.RundeckJobCacheConfig;
import org.rundeck.api.RundeckApiException;
import org.rundeck.api.RundeckClient;
import org.rundeck.api.domain.RundeckJob;

public class InMemoryRundeckJobCache
implements RundeckJobCache {
    private static final Logger log = Logger.getLogger(InMemoryRundeckJobCache.class.getName());
    private static final int RUNDECK_INSTANCE_CACHE_CONTAINER_EXPIRATION_IN_DAYS = 1;
    private final int cacheStatsDisplayHitThreshold;
    private final LoadingCache<String, Cache<String, RundeckJob>> rundeckJobInstanceAwareCache;
    private long hitCounter = 0L;

    public InMemoryRundeckJobCache(final RundeckJobCacheConfig rundeckJobCacheConfig) {
        Objects.requireNonNull(rundeckJobCacheConfig);
        this.cacheStatsDisplayHitThreshold = rundeckJobCacheConfig.getCacheStatsDisplayHitThreshold();
        this.rundeckJobInstanceAwareCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, Cache<String, RundeckJob>>(){

            public Cache<String, RundeckJob> load(String rundeckInstanceName) throws Exception {
                return InMemoryRundeckJobCache.this.createJobCacheForRundeckInstance(rundeckInstanceName, rundeckJobCacheConfig);
            }
        });
    }

    private Cache<String, RundeckJob> createJobCacheForRundeckInstance(String rundeckInstanceName, RundeckJobCacheConfig rundeckJobCacheConfig) {
        log.info(String.format("Loading (GENERATING) jobs cache container for Rundeck instance %s", rundeckInstanceName));
        return CacheBuilder.newBuilder().expireAfterAccess((long)rundeckJobCacheConfig.getAfterAccessExpirationInMinutes(), TimeUnit.MINUTES).maximumSize((long)rundeckJobCacheConfig.getMaximumSize()).build();
    }

    @Override
    public RundeckJob findJobById(String rundeckJobId, String rundeckInstanceName, RundeckClient rundeckInstance) {
        try {
            log.fine(String.format("Cached findJob request for jobId: %s (%s)", rundeckJobId, rundeckInstanceName));
            return this.findByJobIdInCacheOrAskServer(rundeckJobId, rundeckInstanceName, rundeckInstance);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw this.rethrowUnwrappingRundeckApiExceptionIfPossible((Exception)e);
        }
    }

    @Override
    public String logAndGetStats() {
        return this.logStatsAndReturnsAsString();
    }

    private String logStatsAndReturnsAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.rundeckJobInstanceAwareCache.size() == 0L) {
            sb.append("Cache is empty");
        } else {
            for (Map.Entry instanceCacheEntries : this.rundeckJobInstanceAwareCache.asMap().entrySet()) {
                this.logCacheStats((String)instanceCacheEntries.getKey(), (Cache)instanceCacheEntries.getValue());
                sb.append(String.format("%s: %s", instanceCacheEntries.getKey(), ((Cache)instanceCacheEntries.getValue()).stats())).append("\n");
            }
        }
        this.logCacheStats("Meta", (Cache<String, ?>)this.rundeckJobInstanceAwareCache);
        return sb.toString();
    }

    @Override
    public void invalidate() {
        this.logStatsAndReturnsAsString();
        log.info("Rundeck job cache invalidation");
        this.rundeckJobInstanceAwareCache.invalidateAll();
    }

    private RundeckJob findByJobIdInCacheOrAskServer(final String rundeckJobId, String rundeckInstanceName, final RundeckClient rundeckInstance) throws ExecutionException {
        Cache rundeckJobCache = (Cache)this.rundeckJobInstanceAwareCache.get((Object)rundeckInstanceName);
        RundeckJob tmp = (RundeckJob)rundeckJobCache.get((Object)rundeckJobId, (Callable)new Callable<RundeckJob>(){

            @Override
            public RundeckJob call() throws Exception {
                return RundeckNotifier.RundeckDescriptor.findJobUncached(rundeckJobId, rundeckInstance);
            }
        });
        this.logCacheStatsIfAppropriate(rundeckInstanceName, (Cache<String, RundeckJob>)rundeckJobCache);
        return tmp;
    }

    private RuntimeException rethrowUnwrappingRundeckApiExceptionIfPossible(Exception e) {
        if (e.getCause() != null && e.getCause() instanceof RundeckApiException) {
            throw new RundeckApiException(e.getMessage(), (Throwable)e);
        }
        throw Throwables.propagate((Throwable)e);
    }

    private void logCacheStatsIfAppropriate(String instanceName, Cache<String, RundeckJob> jobCache) {
        if (this.cacheStatsDisplayHitThreshold <= 0) {
            return;
        }
        if (++this.hitCounter % (long)this.cacheStatsDisplayHitThreshold == 0L) {
            this.logCacheStats(instanceName, jobCache);
        }
    }

    private void logCacheStats(String instanceName, Cache<String, ?> jobCache) {
        log.info(String.format("%s: %s", instanceName, jobCache.stats()));
    }
}

