/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rundeck.api.RundeckApiException;
import org.rundeck.api.RundeckClient;
import org.rundeck.api.domain.RundeckOutput;
import org.rundeck.api.domain.RundeckOutputEntry;

public class RunDeckLogTail
implements Iterable<List<RundeckOutputEntry>> {
    private static final Logger log = Logger.getLogger(RunDeckLogTail.class.getName());
    private final RundeckClient rundeckClient;
    private final Long executionId;
    private final int maxlines;
    private final int maxRetries;
    private final long sleepRetry;
    private final long sleepUnmodified;
    private final long sleepModified;

    public RunDeckLogTail(RundeckClient rundeckClient, Long executionId) {
        this(rundeckClient, executionId, 50, 5, 15000L, 5000L, 2000L);
    }

    public RunDeckLogTail(RundeckClient rundeckClient, Long executionId, int maxlines, int maxRetries, long sleepRetry, long sleepUnmodified, long sleepModified) {
        this.rundeckClient = rundeckClient;
        this.executionId = executionId;
        this.maxlines = maxlines;
        this.maxRetries = maxRetries;
        this.sleepRetry = sleepRetry;
        this.sleepUnmodified = sleepUnmodified;
        this.sleepModified = sleepModified;
    }

    public RunDeckLogTailIterator iterator() {
        return new RunDeckLogTailIterator();
    }

    protected class RunDeckLogTailIterator
    implements Iterator<List<RundeckOutputEntry>> {
        protected int offset;
        protected boolean completed;
        protected int retries = 0;
        protected int controlMaxlines = RunDeckLogTail.access$000(RunDeckLogTail.this);
        protected List<RundeckOutputEntry> next;

        protected RunDeckLogTailIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.completed) {
                return false;
            }
            this.next = new ArrayList<RundeckOutputEntry>(RunDeckLogTail.this.maxlines);
            try {
                try {
                    log.log(Level.FINE, "Performing API call for executionId [{0}], using offset [{1}]. fetching a maximum of [{2}] lines.", new Object[]{RunDeckLogTail.this.executionId, this.offset, RunDeckLogTail.this.maxlines});
                    RundeckOutput rundeckOutput = RunDeckLogTail.this.rundeckClient.getExecutionOutputState(RunDeckLogTail.this.executionId, false, this.offset, -1L, this.controlMaxlines);
                    this.completed = this.checkCompletionState(rundeckOutput);
                    boolean offsetChanged = this.updateIterationState(rundeckOutput);
                    this.addRunDeckOutputEntriesToResults(rundeckOutput);
                    if (this.checkExecCompletionState(rundeckOutput)) {
                        log.log(Level.FINE, "RunDecks Execution Output is not yet completed but the rundeck job just finished.");
                        this.controlMaxlines = -1;
                    }
                    if (!this.completed) {
                        log.log(Level.FINE, "RunDecks Execution Output is not yet completed. Initializing pause to prevent API hammering");
                        this.handleSleep(offsetChanged);
                    }
                    this.retries = 0;
                }
                catch (RundeckApiException e) {
                    log.log(Level.WARNING, "Caught RuntimeException while handling API call for logs. Will retry for max [{0}] times or rethrow exception.", new Object[]{RunDeckLogTail.this.maxRetries, e});
                    this.sleepOrThrowException((RuntimeException)((Object)e));
                }
            }
            catch (InterruptedException e) {
                log.warning("Caught InterruptedException, will set completed to 'true'.");
                this.completed = true;
            }
            return true;
        }

        private boolean checkCompletionState(RundeckOutput rundeckOutput) {
            return this.checkOutputCompletionState(rundeckOutput) && this.checkExecCompletionState(rundeckOutput);
        }

        private boolean checkExecCompletionState(RundeckOutput rundeckOutput) {
            boolean execCompleted = Boolean.TRUE.equals(rundeckOutput.isExecCompleted());
            log.log(Level.FINE, "Checking completetion state with execCompleted [{0}]", new Object[]{execCompleted});
            return execCompleted;
        }

        private boolean checkOutputCompletionState(RundeckOutput rundeckOutput) {
            boolean outputCompleted = Boolean.TRUE.equals(rundeckOutput.isCompleted());
            log.log(Level.FINE, "Checking completetion state with outputCompleted [{0}]", new Object[]{outputCompleted});
            return outputCompleted;
        }

        private void sleepOrThrowException(RuntimeException e) throws InterruptedException {
            if (this.retries >= RunDeckLogTail.this.maxRetries) {
                log.log(Level.SEVERE, "Giving up after [{0}] retries...", new Object[]{RunDeckLogTail.this.maxRetries, e});
                throw e;
            }
            ++this.retries;
            Thread.sleep(RunDeckLogTail.this.sleepRetry);
        }

        private boolean updateIterationState(RundeckOutput rundeckOutput) {
            int nextOffset = rundeckOutput.getOffset();
            if (this.offset != nextOffset) {
                this.offset = nextOffset;
                log.log(Level.FINE, "Offset is now set to [{0}]", new Object[]{this.offset});
                return true;
            }
            return false;
        }

        private void addRunDeckOutputEntriesToResults(RundeckOutput rundeckOutput) {
            List runDeckOutputEntries = rundeckOutput.getLogEntries();
            if (runDeckOutputEntries != null) {
                this.handleMaxlines(runDeckOutputEntries);
                log.log(Level.FINE, "Got [{0}] rundeckOutputEntries, filtering out empty results and appending resultset.", runDeckOutputEntries.size());
                for (RundeckOutputEntry rundeckOutputEntry : runDeckOutputEntries) {
                    if (rundeckOutputEntry.getMessage() == null) continue;
                    this.next.add(rundeckOutputEntry);
                }
            }
        }

        private void handleMaxlines(List<RundeckOutputEntry> runDeckOutputEntries) {
            if (this.controlMaxlines >= RunDeckLogTail.this.maxlines * 10) {
                this.controlMaxlines = -1;
                log.log(Level.FINE, "Maxlines has changed, requesting all last results");
            } else if (this.controlMaxlines == -1) {
                this.controlMaxlines = RunDeckLogTail.this.maxlines;
                log.log(Level.FINE, "Maxlines has changed, requesting the last [{0}] lines.", this.controlMaxlines);
            } else if (runDeckOutputEntries.size() == this.controlMaxlines) {
                this.controlMaxlines += RunDeckLogTail.this.maxlines;
                log.log(Level.FINE, "Maxlines has changed, requesting the last [{0}] lines.", this.controlMaxlines);
            } else if (runDeckOutputEntries.size() < this.controlMaxlines && this.controlMaxlines > RunDeckLogTail.this.maxlines) {
                this.controlMaxlines -= RunDeckLogTail.this.maxlines;
                log.log(Level.FINE, "Maxlines has changed, requesting the last [{0}] lines.", this.controlMaxlines);
            }
        }

        private void handleSleep(boolean offsetChanged) throws InterruptedException {
            if (offsetChanged) {
                log.log(Level.FINE, "Offset has changed, sleeping for [{0}] ms.", RunDeckLogTail.this.sleepModified);
                Thread.sleep(RunDeckLogTail.this.sleepModified);
            } else {
                log.log(Level.FINE, "Results hasn't changed, sleeping for [{0}] ms.", RunDeckLogTail.this.sleepUnmodified);
                Thread.sleep(RunDeckLogTail.this.sleepUnmodified);
            }
        }

        @Override
        public List<RundeckOutputEntry> next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

