/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rundeck;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.rundeck.RundeckCause;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.rundeck.api.domain.RundeckExecution;
import org.rundeck.api.domain.RundeckJob;

public class RundeckTrigger
extends Trigger<AbstractProject<?, ?>> {
    private final Boolean filterJobs;
    private final List<String> jobsIdentifiers;
    private final List<String> executionStatuses;

    @DataBoundConstructor
    public RundeckTrigger(Boolean filterJobs, List<String> jobsIdentifiers, List<String> executionStatuses) {
        this.filterJobs = filterJobs != null ? filterJobs : false;
        this.jobsIdentifiers = jobsIdentifiers != null ? jobsIdentifiers : new ArrayList();
        this.executionStatuses = executionStatuses != null ? executionStatuses : Arrays.asList("SUCCEEDED");
    }

    public void onNotification(RundeckExecution execution) {
        if (this.shouldScheduleBuild(execution)) {
            ((AbstractProject)this.job).scheduleBuild((Cause)new RundeckCause(execution));
        }
    }

    private boolean shouldScheduleBuild(RundeckExecution execution) {
        if (!this.executionStatuses.contains(execution.getStatus().toString())) {
            return false;
        }
        if (!this.filterJobs.booleanValue()) {
            return true;
        }
        for (String jobIdentifier : this.jobsIdentifiers) {
            if (!this.identifierMatchesJob(jobIdentifier, execution.getJob())) continue;
            return true;
        }
        return false;
    }

    private boolean identifierMatchesJob(String jobIdentifier, RundeckJob job) {
        if (job == null || StringUtils.isBlank((String)jobIdentifier)) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((String)job.getId(), (String)jobIdentifier)) {
            return true;
        }
        String jobReference = job.getProject() + ":" + job.getFullName();
        return StringUtils.equalsIgnoreCase((String)jobReference, (String)jobIdentifier);
    }

    public Boolean getFilterJobs() {
        return this.filterJobs;
    }

    public List<String> getJobsIdentifiers() {
        return this.jobsIdentifiers;
    }

    public List<String> getExecutionStatuses() {
        return this.executionStatuses;
    }

    public RundeckDescriptor getDescriptor() {
        return (RundeckDescriptor)super.getDescriptor();
    }

    @Extension
    public static class RundeckDescriptor
    extends TriggerDescriptor {
        public RundeckDescriptor() {
            this.load();
        }

        public Trigger<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new RundeckTrigger(formData.getJSONObject("filterJobs").getBoolean("value"), this.bindJSONToList(formData.getJSONObject("filterJobs").get("jobsIdentifiers")), this.bindJSONToList(formData.get("executionStatuses")));
        }

        public boolean isApplicable(Item item) {
            return item instanceof AbstractProject;
        }

        public String getDisplayName() {
            return "Build when we receive a notification from Rundeck";
        }

        private List<String> bindJSONToList(Object src) {
            ArrayList<String> result = new ArrayList<String>();
            if (src instanceof String) {
                result.add((String)src);
            } else if (src instanceof JSONObject) {
                result.add(((JSONObject)src).getString("value"));
            } else if (src instanceof JSONArray) {
                for (Object elem : (JSONArray)src) {
                    if (elem instanceof String) {
                        result.add((String)elem);
                        continue;
                    }
                    if (!(elem instanceof JSONObject)) continue;
                    result.add(((JSONObject)elem).getString("value"));
                }
            }
            return result;
        }
    }
}

