/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.logic;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.util.ArrayList;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.logic.ConditionContainer;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class And
extends RunCondition {
    private final ArrayList<ConditionContainer> conditions;

    @DataBoundConstructor
    public And(ArrayList<ConditionContainer> conditions) {
        this.conditions = conditions;
    }

    public ArrayList<ConditionContainer> getConditions() {
        return this.conditions;
    }

    @Override
    public boolean runPrebuild(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        for (ConditionContainer condition : this.conditions) {
            if (condition.runPrebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        for (ConditionContainer condition : this.conditions) {
            if (condition.runPerform(build, listener)) continue;
            return false;
        }
        return true;
    }

    @Extension(ordinal=-1000000.0)
    public static class AndDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.logic_and_displayName();
        }
    }
}

