/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatusCondition
extends AlwaysPrebuildRunCondition {
    private static final Result[] ALL_RESULTS = new Result[]{Result.SUCCESS, Result.UNSTABLE, Result.FAILURE, Result.NOT_BUILT, Result.ABORTED};
    final Result worstResult;
    final Result bestResult;

    private static Result resultFormString(String name) {
        for (Result result : ALL_RESULTS) {
            if (!result.toString().equals(name)) continue;
            return result;
        }
        throw new RuntimeException(Messages.statusCondition_exception_unknownResult(name));
    }

    @DataBoundConstructor
    public StatusCondition(String worstResult, String bestResult) {
        this(StatusCondition.resultFormString(worstResult), StatusCondition.resultFormString(bestResult));
    }

    public StatusCondition(Result worstResult, Result bestResult) {
        this.worstResult = worstResult;
        this.bestResult = bestResult;
    }

    public Result getBestResult() {
        return this.bestResult;
    }

    public Result getWorstResult() {
        return this.worstResult;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) {
        Result currentStatus = build.getResult() == null ? Result.SUCCESS : build.getResult();
        listener.getLogger().println(Messages.statusCondition_check(currentStatus, this.worstResult, this.bestResult));
        return this.worstResult.isWorseOrEqualTo(currentStatus) && this.bestResult.isBetterOrEqualTo(currentStatus);
    }

    @Extension
    public static class StatusConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.statusCondition_displayName();
        }

        public FormValidation doCheckBestResult(@QueryParameter String worstResult, @QueryParameter String bestResult) {
            if (Util.fixEmptyAndTrim((String)worstResult) == null || Util.fixEmptyAndTrim((String)bestResult) == null) {
                return FormValidation.ok();
            }
            return StatusCondition.resultFormString(worstResult).isWorseOrEqualTo(StatusCondition.resultFormString(bestResult)) ? FormValidation.ok() : FormValidation.error((String)Messages.statusCondition_validation_bestWorseThanWorst());
        }

        public FormValidation doCheckWorstResult(@QueryParameter String worstResult, @QueryParameter String bestResult) {
            if (Util.fixEmptyAndTrim((String)worstResult) == null || Util.fixEmptyAndTrim((String)bestResult) == null) {
                return FormValidation.ok();
            }
            return StatusCondition.resultFormString(worstResult).isWorseOrEqualTo(StatusCondition.resultFormString(bestResult)) ? FormValidation.ok() : FormValidation.error((String)Messages.statusCondition_validation_worseBetterThanBest());
        }

        public ListBoxModel doFillWorstResultItems() {
            return this.getResultsModel();
        }

        public ListBoxModel doFillBestResultItems() {
            return this.getResultsModel();
        }

        private ListBoxModel getResultsModel() {
            ListBoxModel items = new ListBoxModel();
            for (Result result : ALL_RESULTS) {
                items.add((Object)new ListBoxModel.Option(result.color.getDescription(), result.toString()));
            }
            return items;
        }
    }
}

