/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.cli.BuildCommand;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.util.ListBoxModel;
import java.util.List;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CauseCondition
extends AlwaysPrebuildRunCondition {
    private final BuildCause buildCause;
    private final boolean exclusiveCause;

    @DataBoundConstructor
    public CauseCondition(String buildCause, boolean exclusiveCause) {
        this.buildCause = BuildCause.valueOf(buildCause);
        this.exclusiveCause = exclusiveCause;
    }

    public BuildCause getBuildCause() {
        return this.buildCause;
    }

    public boolean isExclusiveCause() {
        return this.exclusiveCause;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) {
        String name = this.buildCause == null ? "N/A" : this.buildCause.displayName;
        listener.getLogger().println(Messages.causeCondition_check(name));
        List causes = build.getRootBuild().getCauses();
        if (this.buildCause != null) {
            if (this.isExclusiveCause()) {
                return causes.size() == 1 && this.buildCause.isCausedBy(((Cause)causes.get(0)).getClass().getName());
            }
            for (Cause cause : causes) {
                if (!this.buildCause.isCausedBy(cause.getClass().getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Extension
    public static class CauseConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.causeCondition_displayName();
        }

        public ListBoxModel doFillBuildCauseItems() {
            ListBoxModel items = new ListBoxModel();
            for (BuildCause cause : BuildCause.values()) {
                items.add((Object)new ListBoxModel.Option(cause.displayName, cause.name()));
            }
            return items;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BuildCause {
        USER_CAUSE(Cause.UserCause.class, "UserCause"){

            public boolean isCausedBy(String className) {
                return this.causeClassName.equals(className) || "hudson.model.Cause$UserIdCause".equals(className);
            }
        }
        ,
        CLI_CAUSE(BuildCommand.CLICause.class, "CLICause"),
        REMOTE_CAUSE(Cause.RemoteCause.class, "RemoteCause"),
        SCM_CAUSE(SCMTrigger.SCMTriggerCause.class, "SCMTrigger"),
        TIMER_CAUSE(TimerTrigger.TimerTriggerCause.class, "TimerTrigger"),
        UPSTREAM_CAUSE(Cause.UpstreamCause.class, "UpstreamCause"),
        FS_CAUSE("org.jenkinsci.plugins.fstrigger.FSTriggerCause", "FSTrigger"),
        URL_CAUSE("org.jenkinsci.plugins.urltrigger.URLTriggerCause", "URLTrigger"),
        IVY_CAUSE("org.jenkinsci.plugins.ivytrigger.IvyTriggerCause", "IvyTrigger"),
        SCRIPT_CAUSE("org.jenkinsci.plugins.scripttrigger.ScriptTriggerCause", "ScriptTrigger"),
        BUILDRESULT_CAUSE("org.jenkinsci.plugins.buildresulttrigger.BuildResultTriggerCause", "BuildResultTrigger");

        public final String causeClassName;
        public final String displayName;

        private BuildCause(String causeClassName, String displayName) {
            this.causeClassName = causeClassName;
            this.displayName = displayName;
        }

        boolean isCausedBy(String className) {
            return this.causeClassName.equals(className);
        }

        private BuildCause(Class<? extends Cause> clazz, String displayName) {
            this.causeClassName = clazz.getName();
            this.displayName = displayName;
        }
    }
}

