/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.rolestrategy;

import com.synopsys.arc.jenkins.plugins.rolestrategy.IMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.MacroException;
import com.synopsys.arc.jenkins.plugins.rolestrategy.macros.StubMacro;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;

public abstract class RoleMacroExtension
implements ExtensionPoint,
IMacroExtension {
    private static final Map<String, RoleMacroExtension> NAME_CACHE = new ConcurrentHashMap<String, RoleMacroExtension>();
    private static final Map<String, Macro> MACRO_CACHE = new ConcurrentHashMap<String, Macro>();

    private static void updateRegistry() {
        NAME_CACHE.clear();
        for (RoleMacroExtension ext : RoleMacroExtension.all()) {
            NAME_CACHE.put(ext.getName(), ext);
        }
    }

    @CheckForNull
    public static Macro getMacro(String unparsedMacroString) {
        if (MACRO_CACHE.containsKey(unparsedMacroString)) {
            return MACRO_CACHE.get(unparsedMacroString);
        }
        try {
            Macro m = Macro.parse(unparsedMacroString);
            MACRO_CACHE.put(unparsedMacroString, m);
            return m;
        }
        catch (MacroException ex) {
            MACRO_CACHE.put(unparsedMacroString, null);
            return null;
        }
    }

    public static RoleMacroExtension getMacroExtension(String macroName) {
        RoleMacroExtension ext;
        if (NAME_CACHE.isEmpty()) {
            RoleMacroExtension.updateRegistry();
        }
        return (ext = NAME_CACHE.get(macroName)) != null ? ext : StubMacro.Instance;
    }

    public static ExtensionList<RoleMacroExtension> all() {
        return ExtensionList.lookup(RoleMacroExtension.class);
    }
}

