/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.permissions;

import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.rolestrategy.permissions.DangerousPermissionHandlingMode;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class DangerousPermissionAdministrativeMonitor
extends AdministrativeMonitor {
    public boolean isEnabled() {
        return DangerousPermissionHandlingMode.getCurrent() == DangerousPermissionHandlingMode.UNDEFINED;
    }

    public boolean isActivated() {
        if (DangerousPermissionHandlingMode.getCurrent() != DangerousPermissionHandlingMode.UNDEFINED) {
            return false;
        }
        RoleBasedAuthorizationStrategy roleStrategy = RoleBasedAuthorizationStrategy.getInstance();
        if (roleStrategy == null) {
            return false;
        }
        String report = PermissionHelper.reportDangerousPermissions(roleStrategy);
        return report != null;
    }

    public String getDisplayName() {
        return "Role Strategy. Dangerous permissions";
    }

    @CheckForNull
    public String getReport() {
        RoleBasedAuthorizationStrategy roleStrategy = RoleBasedAuthorizationStrategy.getInstance();
        if (roleStrategy == null) {
            return null;
        }
        return PermissionHelper.reportDangerousPermissions(roleStrategy);
    }

    @CheckForNull
    public static DangerousPermissionAdministrativeMonitor getInstance() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return null;
        }
        return (DangerousPermissionAdministrativeMonitor)((Object)j.getExtensionList(AdministrativeMonitor.class).get(DangerousPermissionAdministrativeMonitor.class));
    }
}

