/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.SidACL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import jenkins.model.Jenkins;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.userdetails.UserDetails;
import org.jenkinsci.plugins.rolestrategy.Settings;
import org.springframework.dao.DataAccessException;

public class RoleMap {
    private final SortedMap<Role, Set<String>> grantedRoles;
    private static final Logger LOGGER = Logger.getLogger(RoleMap.class.getName());
    private final Cache<String, UserDetails> cache = CacheBuilder.newBuilder().softValues().maximumSize((long)Settings.USER_DETAILS_CACHE_MAX_SIZE).expireAfterWrite((long)Settings.USER_DETAILS_CACHE_EXPIRATION_TIME_SEC, TimeUnit.SECONDS).build();

    RoleMap() {
        this.grantedRoles = new TreeMap<Role, Set<String>>();
    }

    RoleMap(SortedMap<Role, Set<String>> grantedRoles) {
        this.grantedRoles = grantedRoles;
    }

    private boolean hasPermission(String sid, Permission p, RoleType roleType, AccessControlled controlledItem) {
        for (Role role : this.getRolesHavingPermission(p)) {
            if (((Set)this.grantedRoles.get(role)).contains(sid)) {
                if (Macro.isMacro(role)) {
                    RoleMacroExtension macroExtension;
                    Macro macro = RoleMacroExtension.getMacro(role.getName());
                    if (macro == null || !(macroExtension = RoleMacroExtension.getMacroExtension(macro.getName())).IsApplicable(roleType) || !macroExtension.hasPermission(sid, p, roleType, controlledItem, macro)) continue;
                    return true;
                }
                return true;
            }
            if (!Settings.TREAT_USER_AUTHORITIES_AS_ROLES) continue;
            try {
                UserDetails userDetails = (UserDetails)this.cache.getIfPresent((Object)sid);
                if (userDetails == null) {
                    userDetails = Jenkins.getInstance().getSecurityRealm().loadUserByUsername(sid);
                    this.cache.put((Object)sid, (Object)userDetails);
                }
                for (GrantedAuthority grantedAuthority : userDetails.getAuthorities()) {
                    if (!grantedAuthority.getAuthority().equals(role.getName())) continue;
                    return true;
                }
            }
            catch (BadCredentialsException e) {
                LOGGER.log(Level.FINE, "Bad credentials", e);
            }
            catch (DataAccessException e) {
                LOGGER.log(Level.FINE, "failed to access the data", e);
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "Unhandled exception during user authorities processing", ex);
            }
        }
        return false;
    }

    public boolean hasRole(Role role) {
        return this.grantedRoles.containsKey(role);
    }

    public SidACL getACL(RoleType roleType, AccessControlled controlledItem) {
        return new AclImpl(roleType, controlledItem);
    }

    public void addRole(Role role) {
        if (this.getRole(role.getName()) == null) {
            this.grantedRoles.put(role, new HashSet());
        }
    }

    public void assignRole(Role role, String sid) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).add(sid);
        }
    }

    public void clearSidsForRole(Role role) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).clear();
        }
    }

    public void clearSids() {
        for (Map.Entry<Role, Set<String>> entry : this.grantedRoles.entrySet()) {
            Role role = entry.getKey();
            this.clearSidsForRole(role);
        }
    }

    public Role getRole(String name) {
        for (Role role : this.getRoles()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public SortedMap<Role, Set<String>> getGrantedRoles() {
        return Collections.unmodifiableSortedMap(this.grantedRoles);
    }

    public Set<Role> getRoles() {
        return Collections.unmodifiableSet(this.grantedRoles.keySet());
    }

    public SortedSet<String> getSids() {
        return this.getSids(false);
    }

    public SortedSet<String> getSids(Boolean includeAnonymous) {
        TreeSet<String> sids = new TreeSet<String>();
        for (Map.Entry<Role, Set<String>> entry : this.grantedRoles.entrySet()) {
            sids.addAll(entry.getValue());
        }
        if (!includeAnonymous.booleanValue()) {
            sids.remove("anonymous");
        }
        return Collections.unmodifiableSortedSet(sids);
    }

    public Set<String> getSidsForRole(String roleName) {
        Role role = this.getRole(roleName);
        if (role != null) {
            return Collections.unmodifiableSet((Set)this.grantedRoles.get(role));
        }
        return null;
    }

    public RoleMap newMatchingRoleMap(String namePattern) {
        Set<Role> roles = this.getMatchingRoles(namePattern);
        TreeMap<Role, Set<String>> roleMap = new TreeMap<Role, Set<String>>();
        for (Role role : roles) {
            roleMap.put(role, (Set<String>)this.grantedRoles.get(role));
        }
        return new RoleMap(roleMap);
    }

    private Set<Role> getRolesHavingPermission(Permission permission) {
        final HashSet<Role> roles = new HashSet<Role>();
        final HashSet<Permission> permissions = new HashSet<Permission>();
        Permission p = permission;
        while (p != null) {
            permissions.add(p);
            p = p.impliedBy;
        }
        new RoleWalker(){

            @Override
            public void perform(Role current) {
                if (current.hasAnyPermission(permissions).booleanValue()) {
                    roles.add(current);
                }
            }
        };
        return roles;
    }

    private Set<Role> getMatchingRoles(final String namePattern) {
        final HashSet<Role> roles = new HashSet<Role>();
        new RoleWalker(){

            @Override
            public void perform(Role current) {
                Matcher m = current.getPattern().matcher(namePattern);
                if (m.matches()) {
                    roles.add(current);
                }
            }
        };
        return roles;
    }

    private abstract class RoleWalker {
        RoleWalker() {
            this.walk();
        }

        public void walk() {
            Set<Role> roles = RoleMap.this.getRoles();
            for (Role current : roles) {
                this.perform(current);
            }
        }

        public abstract void perform(Role var1);
    }

    private final class AclImpl
    extends SidACL {
        AccessControlled item;
        RoleType roleType;

        public AclImpl(RoleType roleType, AccessControlled item) {
            this.item = item;
            this.roleType = roleType;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="As declared in Jenkins API")
        protected Boolean hasPermission(Sid p, Permission permission) {
            if (RoleMap.this.hasPermission(this.toString(p), permission, this.roleType, this.item)) {
                return true;
            }
            return null;
        }
    }
}

