/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.synopsys.arc.jenkins.plugins.rolestrategy.MacroException;
import com.synopsys.arc.jenkins.plugins.rolestrategy.MacroExceptionCode;

public class Macro {
    public static final String MACRO_PREFIX = "@";
    private static final String PARAMS_LEFT_BORDER = "(";
    private static final String PARAMS_RIGHT_BORDER = ")";
    private static final String PARAMS_DELIMITER = "\\\"*,\\\"*";
    private static final String INDEX_DELIMITER = ":";
    private static final int DEFAULT_MACRO_ID = Integer.MIN_VALUE;
    private final String name;
    private final String dispName;
    private final int index;
    private final String[] parameters;

    public Macro(String name, Integer index, String[] parameters) {
        this.name = name;
        this.dispName = MACRO_PREFIX + name;
        this.index = index == null ? Integer.MIN_VALUE : index;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.dispName;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasIndex() {
        return this.index != Integer.MIN_VALUE;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.length != 0;
    }

    public String toString() {
        String str = this.dispName;
        if (this.hasIndex()) {
            str = str + INDEX_DELIMITER + this.index;
        }
        if (this.hasParameters()) {
            str = str + PARAMS_LEFT_BORDER + this.parameters[0];
            for (int i = 1; i < this.parameters.length; ++i) {
                str = str + "," + this.parameters[i];
            }
            str = str + PARAMS_RIGHT_BORDER;
        }
        return str;
    }

    public static boolean isMacro(Role role) {
        return Macro.isMacro(role.getName());
    }

    public static boolean isMacro(String macroString) {
        return macroString.startsWith(MACRO_PREFIX);
    }

    public static Macro Parse(String macroString) throws MacroException {
        int rightBorder;
        if (!Macro.isMacro(macroString)) {
            throw new MacroException(MacroExceptionCode.Not_Macro, "Can't parse macro: Macro String should start from @");
        }
        int leftBorder = macroString.indexOf(PARAMS_LEFT_BORDER);
        boolean hasParams = Macro.checkBorders(macroString, leftBorder, rightBorder = macroString.lastIndexOf(PARAMS_RIGHT_BORDER));
        String macroIdStr = hasParams ? macroString.substring(0, leftBorder) : macroString;
        String[] macroIdItems = macroIdStr.split(INDEX_DELIMITER);
        if (macroIdItems.length > 2) {
            throw new MacroException(MacroExceptionCode.WrongFormat, "Macro string should contain only one ':' delimiter");
        }
        String macroName = macroIdItems[0].substring(MACRO_PREFIX.length());
        if (macroName.isEmpty()) {
            throw new MacroException(MacroExceptionCode.WrongFormat, "Macro name is empty");
        }
        int macroId = Integer.MIN_VALUE;
        if (macroIdItems.length == 2) {
            try {
                macroId = Integer.parseInt(macroIdItems[1]);
            }
            catch (NumberFormatException ex) {
                throw new MacroException(MacroExceptionCode.WrongFormat, "Can't parse int from " + macroIdItems[1] + ": " + ex.getMessage());
            }
        }
        String[] params = null;
        if (hasParams) {
            String paramsStr = macroString.substring(leftBorder + 1, rightBorder);
            params = paramsStr.split(PARAMS_DELIMITER);
        }
        return new Macro(macroName, macroId, params);
    }

    private static boolean checkBorders(String macroStr, int leftBorder, int rightBorder) throws MacroException {
        if (leftBorder == -1 || rightBorder == -1) {
            if (leftBorder == rightBorder) {
                return false;
            }
            String missingBorder = leftBorder == -1 ? "left" : "right";
            throw new MacroException(MacroExceptionCode.WrongFormat, "Missing border: " + missingBorder);
        }
        if (rightBorder != -1 && !macroStr.endsWith(PARAMS_RIGHT_BORDER)) {
            throw new MacroException(MacroExceptionCode.WrongFormat, "Parametrized Macro should end with ')'");
        }
        if (leftBorder != macroStr.lastIndexOf(PARAMS_LEFT_BORDER)) {
            throw new MacroException(MacroExceptionCode.WrongFormat, "Duplicated left border ('(' symbol)");
        }
        if (rightBorder != macroStr.indexOf(PARAMS_RIGHT_BORDER)) {
            throw new MacroException(MacroExceptionCode.WrongFormat, "Duplicated right border (')' symbol)");
        }
        if (macroStr.indexOf("\"") != -1) {
            throw new MacroException(MacroExceptionCode.WrongFormat, "Double quotes aren't supported");
        }
        if (macroStr.indexOf("'") != -1) {
            throw new MacroException(MacroExceptionCode.WrongFormat, "Single quotes aren't supported");
        }
        return true;
    }
}

