/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.SidACL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.acegisecurity.acls.sid.Sid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleMap {
    private final SortedMap<Role, Set<String>> grantedRoles;

    RoleMap() {
        this.grantedRoles = new TreeMap<Role, Set<String>>();
    }

    RoleMap(SortedMap<Role, Set<String>> grantedRoles) {
        this.grantedRoles = grantedRoles;
    }

    private boolean hasPermission(String sid, Permission p, RoleType roleType, AccessControlled controlledItem) {
        for (Role role : this.getRolesHavingPermission(p)) {
            if (!((Set)this.grantedRoles.get(role)).contains(sid)) continue;
            if (Macro.isMacro(role)) {
                RoleMacroExtension macroExtension;
                Macro macro = RoleMacroExtension.getMacro(role.getName());
                if (macro == null || !(macroExtension = RoleMacroExtension.getMacroExtension(macro.getName())).IsApplicable(roleType) || !macroExtension.hasPermission(sid, p, roleType, controlledItem, macro)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean hasRole(Role role) {
        return this.grantedRoles.containsKey(role);
    }

    public SidACL getACL(RoleType roleType, AccessControlled controlledItem) {
        return new AclImpl(roleType, controlledItem);
    }

    public void addRole(Role role) {
        if (this.getRole(role.getName()) == null) {
            this.grantedRoles.put(role, new HashSet());
        }
    }

    public void assignRole(Role role, String sid) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).add(sid);
        }
    }

    public void clearSidsForRole(Role role) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).clear();
        }
    }

    public void clearSids() {
        for (Map.Entry<Role, Set<String>> entry : this.grantedRoles.entrySet()) {
            Role role = entry.getKey();
            this.clearSidsForRole(role);
        }
    }

    public Role getRole(String name) {
        for (Role role : this.getRoles()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public SortedMap<Role, Set<String>> getGrantedRoles() {
        return Collections.unmodifiableSortedMap(this.grantedRoles);
    }

    public Set<Role> getRoles() {
        return Collections.unmodifiableSet(this.grantedRoles.keySet());
    }

    public SortedSet<String> getSids() {
        return this.getSids(false);
    }

    public SortedSet<String> getSids(Boolean includeAnonymous) {
        TreeSet<String> sids = new TreeSet<String>();
        for (Map.Entry<Role, Set<String>> entry : this.grantedRoles.entrySet()) {
            sids.addAll(entry.getValue());
        }
        if (!includeAnonymous.booleanValue()) {
            sids.remove("anonymous");
        }
        return Collections.unmodifiableSortedSet(sids);
    }

    public Set<String> getSidsForRole(String roleName) {
        Role role = this.getRole(roleName);
        if (role != null) {
            return Collections.unmodifiableSet((Set)this.grantedRoles.get(role));
        }
        return null;
    }

    public RoleMap newMatchingRoleMap(String namePattern) {
        Set<Role> roles = this.getMatchingRoles(namePattern);
        TreeMap<Role, Set<String>> roleMap = new TreeMap<Role, Set<String>>();
        for (Role role : roles) {
            roleMap.put(role, (Set<String>)this.grantedRoles.get(role));
        }
        return new RoleMap(roleMap);
    }

    private Set<Role> getRolesHavingPermission(Permission permission) {
        final HashSet<Role> roles = new HashSet<Role>();
        final HashSet<Permission> permissions = new HashSet<Permission>();
        Permission p = permission;
        while (p != null) {
            permissions.add(p);
            p = p.impliedBy;
        }
        new RoleWalker(){

            public void perform(Role current) {
                if (current.hasAnyPermission(permissions).booleanValue()) {
                    roles.add(current);
                }
            }
        };
        return roles;
    }

    private Set<Role> getMatchingRoles(final String namePattern) {
        final HashSet<Role> roles = new HashSet<Role>();
        new RoleWalker(){

            public void perform(Role current) {
                Matcher m = current.getPattern().matcher(namePattern);
                if (m.matches()) {
                    roles.add(current);
                }
            }
        };
        return roles;
    }

    private abstract class RoleWalker {
        RoleWalker() {
            this.walk();
        }

        public void walk() {
            Set<Role> roles = RoleMap.this.getRoles();
            for (Role current : roles) {
                this.perform(current);
            }
        }

        public abstract void perform(Role var1);
    }

    private final class AclImpl
    extends SidACL {
        AccessControlled item;
        RoleType roleType;

        public AclImpl(RoleType roleType, AccessControlled item) {
            this.item = item;
            this.roleType = roleType;
        }

        protected Boolean hasPermission(Sid p, Permission permission) {
            if (RoleMap.this.hasPermission(this.toString(p), permission, this.roleType, this.item)) {
                return true;
            }
            return null;
        }
    }
}

