/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rocketchatnotifier.rocket;

import com.mashape.unirest.request.HttpRequest;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatCallAuthentication;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatRestApiV1;
import jenkins.plugins.rocketchatnotifier.rocket.errorhandling.RocketClientException;

public class RocketChatWebhookAuthentication
implements RocketChatCallAuthentication {
    private static final String HOOKS_PATH = "hooks/";
    private String serverUrl;
    private String webhookUrl;

    public RocketChatWebhookAuthentication(String serverUrl, String webhookToken) {
        this.serverUrl = serverUrl + (serverUrl.endsWith("/") ? "" : "/");
        this.webhookUrl = webhookToken.contains(HOOKS_PATH) ? webhookToken : this.serverUrl + HOOKS_PATH + webhookToken;
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public void doAuthentication() throws RocketClientException {
    }

    @Override
    public String getUrlForRequest(RocketChatRestApiV1 call) {
        switch (call) {
            case Info: {
                return this.serverUrl + "/api/" + call.getMethodName();
            }
            case PostMessage: {
                return this.webhookUrl;
            }
        }
        throw new UnsupportedOperationException("Unable to handle request " + call.name() + " using webhook");
    }

    @Override
    public void addAuthenticationDataToRequest(HttpRequest request) {
    }
}

