/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rocketchatnotifier.rocket;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.GetRequest;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.rocketchatnotifier.RocketClientImpl;
import jenkins.plugins.rocketchatnotifier.model.Response;
import jenkins.plugins.rocketchatnotifier.model.Room;
import jenkins.plugins.rocketchatnotifier.model.User;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatClient;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatClientCallBuilder;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatQueryParams;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatRestApiV1;
import jenkins.plugins.rocketchatnotifier.rocket.errorhandling.RocketClientException;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONValue;

public class RocketChatClientImpl
implements RocketChatClient {
    private static final Logger LOG = Logger.getLogger(RocketClientImpl.class.getName());
    private RocketChatClientCallBuilder callBuilder;

    public RocketChatClientImpl(String serverUrl, boolean trustSSL, String user, String password) throws RocketClientException {
        this.callBuilder = new RocketChatClientCallBuilder(serverUrl, trustSSL, JSONValue.escape((String)user), JSONValue.escape((String)password));
    }

    public RocketChatClientImpl(String serverUrl, boolean trustSSL, String webhookToken) throws RocketClientException {
        LOG.info("Creating new instance for rocket " + serverUrl + " (trustSSL: " + trustSSL + ")");
        this.callBuilder = new RocketChatClientCallBuilder(serverUrl, trustSSL, webhookToken);
    }

    @Override
    public User[] getUsers() throws RocketClientException {
        Response res = this.callBuilder.buildCall(RocketChatRestApiV1.UsersList);
        if (!res.isSuccessful()) {
            LOG.severe("Could not read users information: " + res.getMessage().getMsg());
            throw new RocketClientException("The call to get the User's Information was unsuccessful.");
        }
        if (!res.isUsers()) {
            LOG.severe("Failed to read users information: " + res.getMessage().getMsg());
            throw new RocketClientException("Get User Information failed to retrieve a user.");
        }
        return res.getUsers();
    }

    @Override
    public User getUser(String userId) throws RocketClientException {
        Response res = this.callBuilder.buildCall(RocketChatRestApiV1.UsersInfo, new RocketChatQueryParams("userId", userId));
        if (!res.isSuccessful()) {
            LOG.severe("Could not read user information: " + res.getMessage().getMsg());
            throw new RocketClientException("The call to get the User's Information was unsuccessful.");
        }
        if (!res.isUser()) {
            LOG.severe("Failed to read users information: " + res.getMessage().getMsg());
            throw new RocketClientException("Get User Information failed to retrieve a user.");
        }
        return res.getUser();
    }

    @Override
    public Room[] getChannels() throws RocketClientException {
        Response res = this.callBuilder.buildCall(RocketChatRestApiV1.ChannelsList);
        if (!res.isSuccessful()) {
            LOG.severe("Could not read channels information: " + res.getMessage().getMsg());
            throw new RocketClientException("The call to get the all Channel Information was unsuccessful.");
        }
        return res.getChannels();
    }

    @Override
    public String getInfo() throws RocketClientException {
        Response res;
        try {
            res = this.callBuilder.buildCall(RocketChatRestApiV1.Info);
        }
        catch (Exception e) {
            GetRequest req = Unirest.get((String)(this.callBuilder.getServerUrl() + "/api/v1/info"));
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                res = (Response)objectMapper.readValue((String)req.asString().getBody(), Response.class);
            }
            catch (UnirestException | IOException ex) {
                throw new RocketClientException(e);
            }
        }
        if (res.isSuccessful()) {
            return res.getVersion();
        }
        LOG.severe("Could not read information: " + res);
        throw new RocketClientException("The call to get informations was unsuccessful.");
    }

    @Override
    public void send(Room room, String message) throws CertificateException, RocketClientException {
        this.send(room.getName(), message);
    }

    @Override
    public void send(String channelName, String message) throws CertificateException, RocketClientException {
        this.send(channelName, message, null, null);
    }

    @Override
    public void send(String channelName, String message, String emoji, String avatar) throws CertificateException, RocketClientException {
        this.send(channelName, message, emoji, avatar, null);
    }

    @Override
    public void send(String channelName, String message, String emoji, String avatar, List<Map<String, Object>> attachments) throws CertificateException, RocketClientException {
        if (!channelName.contains(",")) {
            this.sendSingleMessage(channelName, message, emoji, avatar, attachments);
            return;
        }
        for (String singleChanelName : channelName.split(",")) {
            this.sendSingleMessage(singleChanelName, message, emoji, avatar, attachments);
        }
    }

    private void sendSingleMessage(String singleChannelName, String message, String emoji, String avatar, List<Map<String, Object>> attachments) throws RocketClientException {
        Response res;
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)singleChannelName)) {
            String targetChannelName = singleChannelName.trim();
            if (!targetChannelName.matches("^[@#].+")) {
                targetChannelName = "#" + targetChannelName;
            }
            body.put("channel", targetChannelName);
        }
        body.put("text", message);
        if (emoji != null) {
            body.put("emoji", emoji);
        } else if (avatar != null) {
            body.put("avatar", avatar);
        }
        if (attachments != null && attachments.size() > 0) {
            body.put("attachments", attachments);
        }
        if (!(res = this.callBuilder.buildCall(RocketChatRestApiV1.PostMessage, null, body)).isSuccessful()) {
            LOG.severe("Could not send message: " + res);
            throw new RocketClientException("The send of the message was unsuccessful. " + res);
        }
        LOG.fine("Message sent was successfull.");
    }
}

