/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rocketchatnotifier.rocket;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequest;
import com.mashape.unirest.request.HttpRequestWithBody;
import hudson.ProxyConfiguration;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;
import jenkins.plugins.rocketchatnotifier.model.Response;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatBasicCallAuthentication;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatCallAuthentication;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatQueryParams;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatRestApiV1;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatWebhookAuthentication;
import jenkins.plugins.rocketchatnotifier.rocket.errorhandling.RocketClientException;
import jenkins.plugins.rocketchatnotifier.utils.NetworkUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class RocketChatClientCallBuilder {
    private static final Logger logger = Logger.getLogger(RocketChatClientCallBuilder.class.getName());
    private String serverUrl;
    private final ObjectMapper objectMapper;
    private final RocketChatCallAuthentication authentication;

    protected RocketChatClientCallBuilder(String serverUrl, boolean trustSSL, String user, String password) throws RocketClientException {
        this(new RocketChatBasicCallAuthentication(serverUrl, user, password), serverUrl, trustSSL);
        this.serverUrl = serverUrl;
    }

    protected RocketChatClientCallBuilder(String serverUrl, boolean trustSSL, String webhookToken) throws RocketClientException {
        this(new RocketChatWebhookAuthentication(serverUrl, webhookToken), serverUrl, trustSSL);
        this.serverUrl = serverUrl;
    }

    protected RocketChatClientCallBuilder(RocketChatCallAuthentication authentication, String serverUrl, boolean trustSSL) throws RocketClientException {
        this.authentication = authentication;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.serverUrl = serverUrl;
        try {
            Unirest.setHttpClient((HttpClient)RocketChatClientCallBuilder.createHttpClient(serverUrl, trustSSL));
        }
        catch (Exception e) {
            throw new RocketClientException(e);
        }
    }

    protected Response buildCall(RocketChatRestApiV1 call) throws RocketClientException {
        return this.buildCall(call, null, null);
    }

    protected Response buildCall(RocketChatRestApiV1 call, RocketChatQueryParams queryParams) throws RocketClientException {
        return this.buildCall(call, queryParams, null);
    }

    protected Response buildCall(RocketChatRestApiV1 call, RocketChatQueryParams queryParams, Object body) throws RocketClientException {
        if (call.requiresAuth() && !this.authentication.isAuthenticated()) {
            this.authentication.doAuthentication();
        }
        switch (call.getHttpMethod()) {
            case GET: {
                return this.buildGetCall(call, queryParams);
            }
            case POST: {
                return this.buildPostCall(call, queryParams, body);
            }
        }
        throw new RocketClientException("Http Method " + call.getHttpMethod().toString() + " is not supported.");
    }

    private Response buildGetCall(RocketChatRestApiV1 call, RocketChatQueryParams queryParams) throws RocketClientException {
        GetRequest req = Unirest.get((String)this.authentication.getUrlForRequest(call));
        if (call.requiresAuth()) {
            this.authentication.addAuthenticationDataToRequest((HttpRequest)req);
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            for (Map.Entry<? extends String, ? extends String> e : queryParams.get().entrySet()) {
                req.queryString(e.getKey(), (Object)e.getValue());
            }
        }
        try {
            return (Response)this.objectMapper.readValue((String)req.asString().getBody(), Response.class);
        }
        catch (Exception e) {
            throw new RocketClientException(e);
        }
    }

    private Response buildPostCall(RocketChatRestApiV1 call, RocketChatQueryParams queryParams, Object body) throws RocketClientException {
        HttpRequestWithBody req = Unirest.post((String)this.authentication.getUrlForRequest(call)).header("Content-Type", "application/json");
        if (call.requiresAuth()) {
            this.authentication.addAuthenticationDataToRequest((HttpRequest)req);
        }
        if (queryParams != null && !queryParams.isEmpty()) {
            for (Map.Entry<? extends String, ? extends String> e : queryParams.get().entrySet()) {
                req.queryString(e.getKey(), (Object)e.getValue());
            }
        }
        try {
            if (body != null) {
                req.body(this.objectMapper.writeValueAsString(body));
            }
            HttpResponse res = req.asString();
            return (Response)this.objectMapper.readValue((String)res.getBody(), Response.class);
        }
        catch (Exception e) {
            throw new RocketClientException(e);
        }
    }

    private static HttpClient createHttpClient(String serverUrl, boolean trustSSL) throws KeyManagementException, NoSuchAlgorithmException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        RocketChatClientCallBuilder.setConnectionManager(httpClientBuilder, trustSSL);
        ProxyConfiguration proxyConfiguration = RocketChatClientCallBuilder.getProxyConfiguration(serverUrl);
        if (proxyConfiguration != null) {
            RocketChatClientCallBuilder.setProxy(httpClientBuilder, proxyConfiguration);
        }
        return httpClientBuilder.build();
    }

    private static void setConnectionManager(HttpClientBuilder httpClientBuilder, boolean trustSSL) throws NoSuchAlgorithmException, KeyManagementException {
        PoolingHttpClientConnectionManager manager;
        if (trustSSL) {
            SSLContext sslContext = RocketChatClientCallBuilder.createAlwaysTrustingSSLContext();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
            manager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        } else {
            manager = new PoolingHttpClientConnectionManager();
        }
        manager.setDefaultMaxPerRoute(20);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)manager);
    }

    private static SSLContext createAlwaysTrustingSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }}, new SecureRandom());
        return sslContext;
    }

    private static ProxyConfiguration getProxyConfiguration(String serverUrl) {
        Jenkins jenkinsInstance = Jenkins.getInstanceOrNull();
        return jenkinsInstance != null && jenkinsInstance.proxy != null && !NetworkUtils.isHostOnNoProxyList(serverUrl, jenkinsInstance.proxy) ? jenkinsInstance.proxy : null;
    }

    private static void setProxy(HttpClientBuilder httpClientBuilder, ProxyConfiguration proxyConfiguration) {
        HttpHost proxyHost = new HttpHost(proxyConfiguration.name, proxyConfiguration.port);
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
        httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        String username = proxyConfiguration.getUserName();
        if (username != null && !username.trim().isEmpty()) {
            logger.info("Using proxy authentication (user=" + username + ")");
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(username, proxyConfiguration.getPassword()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }
}

