/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rocketchatnotifier.model;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jenkins.plugins.rocketchatnotifier.utils.IgnoreInheritedIntrospector;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessageAttachment
extends AbstractDescribableImpl<MessageAttachment> {
    private String color;
    private String text;
    private String ts;
    @JsonProperty(value="thumb_url")
    private String thumbUrl;
    @JsonProperty(value="message_link")
    private String messageLink;
    private Boolean collapsed;
    @JsonProperty(value="author_name")
    private String authorName;
    private final String title;
    @JsonProperty(value="author_link")
    private String authorLink;
    @JsonProperty(value="author_icon")
    private String authorIcon;
    @JsonProperty(value="title_link")
    private String titleLink;
    @JsonProperty(value="title_link_download")
    private Boolean titleLinkDownload;
    @JsonProperty(value="image_url")
    private String imageUrl;
    @JsonProperty(value="audio_url")
    private String audioUrl;
    @JsonProperty(value="video_url")
    private String videoUrl;

    @DataBoundConstructor
    public MessageAttachment(String title) {
        this.title = title;
    }

    public String getColor() {
        return this.color;
    }

    @DataBoundSetter
    public void setColor(String color) {
        this.color = color;
    }

    public String getText() {
        return this.text;
    }

    @DataBoundSetter
    public void setText(String text) {
        this.text = text;
    }

    public String getTs() {
        return this.ts;
    }

    @DataBoundSetter
    public void setTs(String ts) {
        this.ts = ts;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    @DataBoundSetter
    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public String getMessageLink() {
        return this.messageLink;
    }

    @DataBoundSetter
    public void setMessageLink(String messageLink) {
        this.messageLink = messageLink;
    }

    @DataBoundSetter
    public void setCollapsed(Boolean collapsed) {
        if (collapsed.booleanValue()) {
            this.collapsed = collapsed;
        }
    }

    public String getAuthorName() {
        return this.authorName;
    }

    @DataBoundSetter
    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getCollapsed() {
        return this.collapsed;
    }

    public String getAuthorLink() {
        return this.authorLink;
    }

    public void setAuthorLink(String authorLink) {
        this.authorLink = authorLink;
    }

    public String getAuthorIcon() {
        return this.authorIcon;
    }

    @DataBoundSetter
    public void setAuthorIcon(String authorIcon) {
        this.authorIcon = authorIcon;
    }

    public String getTitleLink() {
        return this.titleLink;
    }

    @DataBoundSetter
    public void setTitleLink(String titleLink) {
        this.titleLink = titleLink;
    }

    public Boolean getTitleLinkDownload() {
        return this.titleLinkDownload;
    }

    @DataBoundSetter
    public void setTitleLinkDownload(Boolean titleLinkDownload) {
        if (titleLinkDownload.booleanValue()) {
            this.titleLinkDownload = titleLinkDownload;
        }
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    @DataBoundSetter
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getAudioUrl() {
        return this.audioUrl;
    }

    @DataBoundSetter
    public void setAudioUrl(String audioUrl) {
        this.audioUrl = audioUrl;
    }

    public String getVideoUrl() {
        return this.videoUrl;
    }

    @DataBoundSetter
    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public static MessageAttachment fromJSON(JSONObject json) {
        MessageAttachment attachment = new MessageAttachment(json.optString("title"));
        attachment.setColor(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("color")));
        attachment.setText(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("text")));
        attachment.setThumbUrl(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("thumbUrl")));
        attachment.setMessageLink(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("messageLink")));
        attachment.setCollapsed(json.getBoolean("collapsed"));
        attachment.setAuthorName(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("authorName")));
        attachment.setAuthorIcon(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("authorIcon")));
        attachment.setAuthorLink(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("authorLink")));
        attachment.setTitleLink(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("titleLink")));
        attachment.setTitleLinkDownload(json.getBoolean("titleLinkDownload"));
        attachment.setImageUrl(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("imageUrl")));
        attachment.setAudioUrl(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("audioUrl")));
        attachment.setVideoUrl(MessageAttachment.sanitizeEmptyStringtoNull(json.getString("videoUrl")));
        return attachment;
    }

    private static String sanitizeEmptyStringtoNull(String text) {
        return text == null || text.length() == 0 ? null : text;
    }

    public static List<Map<String, Object>> convertMessageAttachmentsToMaps(List<MessageAttachment> attachments) {
        ArrayList<Map<String, Object>> returnedList = new ArrayList<Map<String, Object>>();
        if (attachments != null && attachments.size() > 0) {
            ObjectMapper oMapper = new ObjectMapper();
            oMapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreInheritedIntrospector());
            for (MessageAttachment attachment : attachments) {
                returnedList.add((Map<String, Object>)oMapper.convertValue((Object)attachment, Map.class));
            }
        }
        return returnedList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MessageAttachment that = (MessageAttachment)((Object)o);
        return Objects.equals(this.color, that.color) && Objects.equals(this.text, that.text) && Objects.equals(this.ts, that.ts) && Objects.equals(this.thumbUrl, that.thumbUrl) && Objects.equals(this.messageLink, that.messageLink) && Objects.equals(this.collapsed, that.collapsed) && Objects.equals(this.authorName, that.authorName) && Objects.equals(this.title, that.title) && Objects.equals(this.authorLink, that.authorLink) && Objects.equals(this.authorIcon, that.authorIcon) && Objects.equals(this.titleLink, that.titleLink) && Objects.equals(this.titleLinkDownload, that.titleLinkDownload) && Objects.equals(this.imageUrl, that.imageUrl) && Objects.equals(this.audioUrl, that.audioUrl) && Objects.equals(this.videoUrl, that.videoUrl);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.text, this.ts, this.thumbUrl, this.messageLink, this.collapsed, this.authorName, this.title, this.authorLink, this.authorIcon, this.titleLink, this.titleLinkDownload, this.imageUrl, this.audioUrl, this.videoUrl);
    }

    @Extension
    @JsonIgnoreType
    public static class DescriptorImpl
    extends Descriptor<MessageAttachment> {
        public String getDisplayName() {
            return "";
        }
    }
}

