/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.view;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.RobotConfig;
import hudson.plugins.robot.model.RobotResult;
import hudson.views.ListViewColumn;
import javax.inject.Inject;
import org.kohsuke.stapler.DataBoundConstructor;

public class RobotListViewColumn
extends ListViewColumn {
    @DataBoundConstructor
    public RobotListViewColumn() {
    }

    public String getColumnCaption() {
        return this.getDescriptor().getDisplayName();
    }

    public long getPass(Job job) {
        RobotResult lastRobotResult = this.getLastRobotResult(job);
        if (lastRobotResult != null) {
            return lastRobotResult.getOverallPassed();
        }
        return 0L;
    }

    public long getTotal(Job job) {
        RobotResult lastRobotResult = this.getLastRobotResult(job);
        if (lastRobotResult != null) {
            return lastRobotResult.getOverallTotal();
        }
        return 0L;
    }

    public double getPassPercent(Job job) {
        RobotResult lastRobotResult = this.getLastRobotResult(job);
        if (lastRobotResult == null) {
            return 100.0;
        }
        return lastRobotResult.getPassPercentage();
    }

    public String getRobotPath(Job job) {
        Run build = job.getLastCompletedBuild();
        int lastBuildNr = build == null ? 1 : build.number;
        return job.getShortUrl() + lastBuildNr + "/robot/";
    }

    public String getLogUrl(Job job) {
        return this.getRobotPath(job) + "report/log.html";
    }

    public String getTrendUrl(Job job) {
        return this.getRobotPath(job) + "durationGraph?maxBuildsToShow=" + this.getBuildsToShowInResultsColumn();
    }

    public String getTrendHdUrl(Job job) {
        return this.getTrendUrl(job) + "&hd";
    }

    public String getTrendPreviewUrl(Job job) {
        return this.getTrendUrl(job) + "&preview";
    }

    private RobotResult getLastRobotResult(Job job) {
        RobotBuildAction action;
        Run build = job.getLastCompletedBuild();
        if (build != null && (action = (RobotBuildAction)build.getAction(RobotBuildAction.class)) != null) {
            return action.getResult();
        }
        return null;
    }

    public int getBuildsToShowInResultsColumn() {
        return ((DescriptorImpl)this.getDescriptor()).getBuildsToShowInResultsColumn();
    }

    public boolean isRobotResultsColumnEnabled() {
        return ((DescriptorImpl)this.getDescriptor()).isRobotResultsColumnEnabled();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<ListViewColumn> {
        @Inject
        private RobotConfig globalConfig;

        public String getDisplayName() {
            return "Robot pass/fail";
        }

        public boolean isRobotResultsColumnEnabled() {
            return this.globalConfig.isRobotResultsColumnEnabled();
        }

        public int getBuildsToShowInResultsColumn() {
            return this.globalConfig.getBuildsToShowInResultsColumn();
        }
    }
}

