/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.auth;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.jenkinsci.plugins.reverse_proxy_auth.ReverseProxySecurityRealm;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.ReverseProxyAuthenticator;
import org.jenkinsci.plugins.reverse_proxy_auth.model.ReverseProxyUserDetails;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.util.Assert;

public class DefaultReverseProxyAuthenticator
implements ReverseProxyAuthenticator,
InitializingBean,
MessageSourceAware {
    private static final Logger LOGGER = Logger.getLogger(ReverseProxySecurityRealm.class.getName());
    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="It is a part of public API :(")
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private final String username;
    private final GrantedAuthority[] authorities;

    public DefaultReverseProxyAuthenticator(String username, @CheckForNull GrantedAuthority[] authorities) {
        this.username = username;
        this.authorities = authorities != null ? Arrays.copyOf(authorities, authorities.length) : null;
    }

    public void setMessageSource(@NonNull MessageSource messageSource) {
        Assert.notNull((Object)"Message source must not be null");
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void afterPropertiesSet() throws Exception {
    }

    @Override
    public ReverseProxyUserDetails authenticate(String username, String password) throws DataAccessException {
        Object principal;
        LOGGER.log(Level.INFO, "DefaultReverseProxyAuthenticator::authenticate ==> {0} to {1}", new Object[]{this.username, this.authorities});
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            auth = new UsernamePasswordAuthenticationToken((Object)this.username, (Object)"", this.authorities);
            SecurityContextHolder.getContext().setAuthentication(auth);
        }
        if ((principal = auth.getPrincipal()) instanceof ReverseProxyUserDetails) {
            return (ReverseProxyUserDetails)principal;
        }
        if (principal instanceof String) {
            ReverseProxyUserDetails details = new ReverseProxyUserDetails();
            details.setUsername((String)principal);
            details.setAuthorities(auth.getAuthorities());
            return details;
        }
        throw new InvalidDataAccessApiUsageException("Cannot convert principal " + principal + " to ReverseProxyUserDetails. Principal type is " + (principal == null ? "null" : principal.toString()));
    }
}

