/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.model.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.model.Item;
import hudson.model.Run;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class DeleteBuildRequest
extends Request {
    private static final Logger LOGGER = Logger.getLogger(DeleteBuildRequest.class.getName());

    public DeleteBuildRequest(String requestType, String username, String project, String projectFullName, String buildNumber) {
        super(requestType, username, project, projectFullName, buildNumber);
    }

    @Override
    public String getMessage() {
        return Messages.DeleteBuildRequest_message(this.buildNumber + " for " + this.project);
    }

    @Override
    public boolean execute(Item item) {
        boolean success;
        block15: {
            Jenkins jenkins = null;
            success = false;
            StringBuffer stringBuffer = new StringBuffer();
            String[] projectList = null;
            LOGGER.info("[DEBUG] : " + this.project);
            try {
                jenkins = Jenkins.get();
                if (jenkins == null) {
                    throw new NullPointerException("Jenkins instance is null");
                }
                if (Jenkins.get().hasPermission(Run.DELETE)) {
                    String returnStatus;
                    block14: {
                        String jenkinsURL = null;
                        jenkinsURL = Jenkins.get().getRootUrl();
                        if (jenkinsURL == null) {
                            throw new NullPointerException("Jenkins instance is null");
                        }
                        if (!this.projectFullName.contains("/job/") && this.projectFullName.contains("/")) {
                            projectList = this.projectFullName.split("/");
                            int nameCount = projectList.length;
                            stringBuffer.append(projectList[0]);
                            for (int i = 1; i < nameCount; ++i) {
                                stringBuffer.append("/job/");
                                stringBuffer.append(projectList[i]);
                            }
                            this.projectFullName = stringBuffer.toString();
                        }
                        String urlString = jenkinsURL + "job/" + this.projectFullName + "/" + this.buildNumber + "/doDelete";
                        RequestsUtility requestsUtility = new RequestsUtility();
                        LOGGER.info("[INFO] Delete Build urlString: " + urlString);
                        try {
                            returnStatus = requestsUtility.runPostMethod(jenkinsURL, urlString);
                            if (!returnStatus.contains("Forbidden") && !returnStatus.contains("Bad Request")) break block14;
                            String unlockUrlString = jenkinsURL + "job/" + this.projectFullName + "/" + this.buildNumber + "/toggleLogKeep";
                            try {
                                returnStatus = requestsUtility.runPostMethod(jenkinsURL, unlockUrlString);
                                if (!returnStatus.equals("success")) {
                                    this.errorMessage = "Build is locked. Unlock Build call has failed for " + this.projectFullName + ":" + this.buildNumber + " : " + returnStatus;
                                    LOGGER.log(Level.INFO, "Build is locked. Unlock Build call has failed: ", this.projectFullName + ":" + this.buildNumber + " : " + returnStatus);
                                    return false;
                                }
                                this.errorMessage = "Build number " + this.buildNumber + " has been properly Unlocked for " + this.projectFullName;
                                LOGGER.log(Level.INFO, "Build {0} has been properly Unlocked", this.projectFullName + ":" + this.buildNumber);
                            }
                            catch (IOException e) {
                                this.errorMessage = e.getMessage();
                                LOGGER.log(Level.SEVERE, "Unable to Unlock the build " + this.projectFullName + ":" + this.buildNumber, e.getMessage());
                                return false;
                            }
                            returnStatus = requestsUtility.runPostMethod(jenkinsURL, urlString);
                        }
                        catch (IOException e) {
                            this.errorMessage = e.getMessage();
                            LOGGER.log(Level.SEVERE, "Unable to Delete the build " + this.projectFullName + ":" + this.buildNumber, e.getMessage());
                            return false;
                        }
                    }
                    if (returnStatus.equals("success")) {
                        this.errorMessage = "Build number " + this.buildNumber + " has been properly Deleted for " + this.projectFullName;
                        LOGGER.log(Level.INFO, "Build {0} has been properly Deleted", this.projectFullName + ":" + this.buildNumber);
                        success = true;
                    } else {
                        this.errorMessage = "Delete Build call has failed for " + this.projectFullName + ":" + this.buildNumber + " : " + returnStatus;
                        LOGGER.log(Level.INFO, "Delete Build call has failed: ", this.projectFullName + ":" + this.buildNumber + " : " + returnStatus);
                    }
                    break block15;
                }
                this.errorMessage = "The current user " + this.username + " does not have permission to delete the build";
                LOGGER.log(Level.FINE, "The current user {0} does not have permission to DELETE the build", new Object[]{this.username});
                LOGGER.log(Level.FINE, "The current user does not have the DELETE permission");
            }
            catch (NullPointerException e) {
                this.errorMessage = e.getMessage();
                LOGGER.log(Level.SEVERE, "Unable to Delete the build " + this.projectFullName + ":" + this.buildNumber, e.getMessage());
                return false;
            }
        }
        return success;
    }
}

