/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.action.RequestMailSender;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class RequestsUtility {
    private static final Logger LOGGER = Logger.getLogger(RequestsUtility.class.getName());

    public String runPostMethod(String jenkinsURL, String urlString) throws ClientProtocolException, IOException {
        String returnStatus;
        LOGGER.info("[INFO] urlString: " + urlString);
        RequestMailSender.DescriptorEmailImpl descriptorEmailImpl = new RequestMailSender.DescriptorEmailImpl();
        String username = descriptorEmailImpl.getUnlockuser();
        Secret password = descriptorEmailImpl.getUnlockpassword();
        URI uri = URI.create(urlString);
        HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(username, password.getPlainText()));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(host, (AuthScheme)basicAuth);
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        HttpPost httpPost = new HttpPost(uri);
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        CloseableHttpResponse response = httpClient.execute(host, (HttpRequest)httpPost, (HttpContext)localContext);
        int responseCode = response.getStatusLine().getStatusCode();
        LOGGER.info("[INFO] responseCode: " + responseCode);
        if (responseCode > 199 && responseCode < 400) {
            returnStatus = "success";
        } else {
            LOGGER.info("[ERROR] httpClient getReasonPhrase: " + response.getStatusLine().getReasonPhrase());
            returnStatus = response.getStatusLine().getReasonPhrase();
        }
        return returnStatus;
    }

    public String constructFolderJobName(String inputName) {
        String[] projectNameList = null;
        StringBuffer stringBuffer = new StringBuffer();
        projectNameList = inputName.split("/");
        int nameCount = projectNameList.length;
        stringBuffer.append(projectNameList[0]);
        for (int i = 1; i < nameCount; ++i) {
            stringBuffer.append("/job/");
            stringBuffer.append(projectNameList[i]);
        }
        return stringBuffer.toString();
    }

    public String[] constructFolderJobNameAndFull(String inputName) {
        String[] projectNameList = null;
        String[] returnNameList = new String[2];
        StringBuffer stringBuffer = new StringBuffer();
        String projectName = "";
        projectNameList = inputName.split(" \u00bb ");
        int nameCount = projectNameList.length;
        stringBuffer.append(projectNameList[0]);
        for (int i = 1; i < nameCount; ++i) {
            if (i + 1 == nameCount) {
                stringBuffer.append("/job/");
                stringBuffer.append(projectNameList[i].split(" ")[0]);
                projectName = projectNameList[i].split(" ")[0];
                continue;
            }
            stringBuffer.append("/job/");
            stringBuffer.append(projectNameList[i]);
        }
        returnNameList[0] = projectName;
        returnNameList[1] = stringBuffer.toString();
        return returnNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCrumb(URL url) {
        String[] crumbArray = new String[2];
        String[] returnValues = new String[3];
        String crumbAvailable = "false";
        BufferedReader reader = null;
        try {
            String line;
            RequestMailSender.DescriptorEmailImpl descriptorEmailImpl = new RequestMailSender.DescriptorEmailImpl();
            String authStr = descriptorEmailImpl.getUnlockuser() + ":" + descriptorEmailImpl.getUnlockpassword();
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])authStr.getBytes("utf-8"));
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
            httpsURLConnection.setRequestMethod("GET");
            httpsURLConnection.setUseCaches(false);
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestProperty("Authorization", basicAuth);
            InputStream inputStream = httpsURLConnection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder out = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
            String crumbValue = out.toString();
            crumbArray = crumbValue.split(":");
            inputStream.close();
            crumbAvailable = "true";
        }
        catch (IOException ioe) {
            crumbArray[0] = "";
            crumbArray[1] = "";
            crumbAvailable = "false";
            LOGGER.warning("No crumb available: " + ioe.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOGGER.warning("[ERROR]: Unable to close reader" + e.getMessage());
            }
        }
        returnValues[0] = crumbArray[0];
        returnValues[1] = crumbArray[1];
        returnValues[2] = crumbAvailable;
        return returnValues;
    }
}

