/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.model.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.model.Item;
import hudson.model.Run;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class UnlockRequest
extends Request {
    private static final Logger LOGGER = Logger.getLogger(UnlockRequest.class.getName());

    public UnlockRequest(String requestType, String username, String project, String projectFullName, String buildNumber) {
        super(requestType, username, project, projectFullName, buildNumber);
    }

    @Override
    public String getMessage() {
        return Messages.UnlockRequest_message(this.buildNumber + " for " + this.project);
    }

    @Override
    public boolean execute(Item item) {
        boolean success;
        block13: {
            Jenkins jenkins = null;
            success = false;
            String returnStatus = null;
            try {
                jenkins = Jenkins.get();
                if (jenkins == null) {
                    throw new NullPointerException("Jenkins instance is null");
                }
                if (Jenkins.get() != null && Jenkins.get().hasPermission(Run.DELETE)) {
                    try {
                        String jenkinsURL = null;
                        try {
                            jenkinsURL = Jenkins.get().getRootUrl();
                            if (jenkinsURL == null) {
                                throw new NullPointerException("Jenkins instance is null");
                            }
                        }
                        catch (Exception npe) {
                            LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + npe.getMessage().toString());
                            return false;
                        }
                        RequestsUtility requestsUtility = new RequestsUtility();
                        this.projectFullName = this.projectFullName.replace(" ", "%20");
                        String urlString = jenkinsURL + "job/" + this.projectFullName + "/" + this.buildNumber + "/toggleLogKeep";
                        try {
                            returnStatus = requestsUtility.runPostMethod(jenkinsURL, urlString);
                        }
                        catch (Exception e) {
                            this.errorMessage = "Unable to Unlock the build: " + e.getMessage();
                            LOGGER.log(Level.SEVERE, "Unable to Unlock the build " + this.projectFullName + ":" + this.buildNumber, e.getMessage().toString());
                            return false;
                        }
                        if (returnStatus.equals("success")) {
                            this.errorMessage = "Build number " + this.buildNumber + " has been properly Unlocked for " + this.projectFullName;
                            LOGGER.log(Level.INFO, "Build {0} has been properly Unlocked", this.projectFullName + ":" + this.buildNumber);
                            success = true;
                            break block13;
                        }
                        if (returnStatus.contains("Forbidden")) {
                            this.errorMessage = "The current user " + this.username + " does not have permission to Unlock the Build";
                            LOGGER.log(Level.SEVERE, "The current user {0} does not have permission to Unlock the Build", new Object[]{this.username});
                            success = false;
                            break block13;
                        }
                        this.errorMessage = "UNLOCK Build request has failed for " + this.projectFullName + ":" + this.buildNumber + " : " + returnStatus.toString();
                        LOGGER.log(Level.INFO, "UNLOCK Build call has failed: ", this.projectFullName + ":" + this.buildNumber + " : " + returnStatus.toString());
                        success = false;
                    }
                    catch (Exception e) {
                        this.errorMessage = "Unable to UNLOCK the Build: " + e.getMessage();
                        LOGGER.log(Level.SEVERE, "Unable to UNLOCK the Build " + this.projectFullName + ":" + this.buildNumber, e.getMessage().toString());
                    }
                    break block13;
                }
                this.errorMessage = "The current user " + this.username + " does not have permission to UNLOCK the Build";
                LOGGER.log(Level.FINE, "The current user {0} does not have permission to UNLOCK the Build", new Object[]{this.username});
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + e.getMessage().toString());
                return false;
            }
        }
        return success;
    }
}

