/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.action.RequestMailSender;
import hudson.util.Secret;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class RequestsUtility {
    private static final Logger LOGGER = Logger.getLogger(RequestsUtility.class.getName());

    public String runPostMethod(String jenkinsURL, String urlString) throws ClientProtocolException, IOException {
        String returnStatus;
        LOGGER.info("[INFO] urlString: " + urlString);
        try {
            RequestMailSender.DescriptorEmailImpl descriptorEmailImpl = new RequestMailSender.DescriptorEmailImpl();
            String username = descriptorEmailImpl.getUnlockuser();
            Secret password = descriptorEmailImpl.getUnlockpassword();
            URI uri = URI.create(urlString);
            HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(username, password.getPlainText()));
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(host, (AuthScheme)basicAuth);
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            HttpPost httpPost = new HttpPost(uri);
            HttpClientContext localContext = HttpClientContext.create();
            localContext.setAuthCache((AuthCache)authCache);
            CloseableHttpResponse response = httpClient.execute(host, (HttpRequest)httpPost, (HttpContext)localContext);
            int responseCode = response.getStatusLine().getStatusCode();
            LOGGER.info("[INFO] responseCode: " + responseCode);
            if (responseCode > 199 && responseCode < 400) {
                returnStatus = "success";
            } else {
                LOGGER.info("[ERROR] httpClient getReasonPhrase: " + response.getStatusLine().getReasonPhrase());
                returnStatus = response.getStatusLine().getReasonPhrase();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to Delete the build " + e.getMessage().toString());
            returnStatus = e.getMessage().toString();
        }
        return returnStatus;
    }

    public String constructFolderJobName(String inputName) {
        String[] projectNameList = null;
        StringBuffer stringBuffer = new StringBuffer();
        projectNameList = inputName.split("/");
        int nameCount = projectNameList.length;
        stringBuffer.append(projectNameList[0]);
        for (int i = 1; i < nameCount; ++i) {
            stringBuffer.append("/job/");
            stringBuffer.append(projectNameList[i]);
        }
        LOGGER.info("[INFO] FULL FOLDER PROJECT NAME: " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }
}

