/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import hudson.model.Item;
import java.util.Calendar;
import jenkins.model.Jenkins;
import org.apache.commons.lang.time.FastDateFormat;

public abstract class Request {
    protected String requestType;
    protected String username;
    protected String project;
    protected String projectFullName;
    protected String buildNumber;
    protected String errorMessage;
    private String creationDate;
    private static String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private static final FastDateFormat yyyymmdd = FastDateFormat.getInstance((String)dateFormat);

    public Request(String requestType, String username, String project, String projectFullName, String buildNumber) {
        this.requestType = requestType;
        this.username = username;
        this.project = project;
        this.projectFullName = projectFullName;
        this.buildNumber = buildNumber;
        this.creationDate = yyyymmdd.format(Calendar.getInstance().getTime());
    }

    public String getProject() {
        if (this.projectFullName.contains("/")) {
            String[] projectList = this.projectFullName.split("/");
            int nameCount = projectList.length;
            this.project = projectList[nameCount - 1];
        }
        return this.project;
    }

    public String getProjectNameWithoutJobSeparator() {
        String projectFullNameWithoutJobSeparator;
        String[] projectList = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.projectFullName.contains("/job/")) {
            projectList = this.projectFullName.split("/job/");
            int nameCount = projectList.length;
            stringBuffer.append(projectList[0]);
            for (int i = 1; i < nameCount; ++i) {
                stringBuffer.append("/" + projectList[i]);
            }
            projectFullNameWithoutJobSeparator = stringBuffer.toString();
        } else {
            projectFullNameWithoutJobSeparator = this.projectFullName;
        }
        return projectFullNameWithoutJobSeparator;
    }

    public String getProjectFullName() {
        return this.projectFullName;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public abstract String getMessage();

    public boolean process(String requestType) {
        boolean success = false;
        String projectName = this.getProjectNameWithoutJobSeparator();
        try {
            Item item = Jenkins.get().getItemByFullName(projectName);
            if (item != null) {
                success = this.execute(item);
            } else {
                if (requestType.equals("deleteJob") || requestType.equals("renameJob")) {
                    this.errorMessage = "The job " + projectName + " doesn't exist";
                }
                this.errorMessage = requestType.equals("deleteFolder") || requestType.equals("renameFolder") ? "The folder " + projectName + " doesn't exist" : "The build for " + projectName + " doesn't exist";
            }
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage().toString();
            return false;
        }
        return success;
    }

    public abstract boolean execute(Item var1);
}

