/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.model.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import hudson.model.Item;
import hudson.model.Job;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class RenameJobRequest
extends Request {
    private String newName;
    private static final Logger LOGGER = Logger.getLogger(RenameJobRequest.class.getName());

    public RenameJobRequest(String requestType, String username, String project, String projectFullName, String newName) {
        super(requestType, username, project, projectFullName, newName);
        this.newName = newName;
    }

    @Override
    public String getMessage() {
        return Messages.RenameJobRequest_message(this.project, this.newName);
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    public boolean execute(Item item) {
        boolean success = false;
        try {
            if (Jenkins.get().hasPermission(Item.DELETE) && !Jenkins.get().hasPermission(Item.CREATE) && Jenkins.get().hasPermission(Item.CONFIGURE) || !Jenkins.get().hasPermission(Item.DELETE) && Jenkins.get().hasPermission(Item.CREATE) && Jenkins.get().hasPermission(Item.CONFIGURE) || Jenkins.get().hasPermission(Item.DELETE) && Jenkins.get().hasPermission(Item.CREATE) && Jenkins.get().hasPermission(Item.CONFIGURE)) {
                ((Job)item).renameTo(this.newName);
                success = true;
                LOGGER.log(Level.INFO, "The Job {0} has been properly renamed in {1}", new Object[]{item.getName(), this.newName});
            } else {
                this.errorMessage = "The current user " + this.username + " has no permission to RENAME the Job";
                LOGGER.log(Level.FINE, "The current user {0} has no permission to RENAME the Job", new Object[]{this.username});
            }
        }
        catch (Exception e) {
            this.errorMessage = "Unable to RENAME the Job " + e.getMessage().toString();
            LOGGER.log(Level.SEVERE, "Unable to RENAME the Job " + item.getName(), e.getMessage().toString());
        }
        return success;
    }
}

