/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.michelin.cio.jenkins.plugin.requests.model.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import hudson.model.Item;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class RenameFolderRequest
extends Request {
    private String newName;
    private static final Logger LOGGER = Logger.getLogger(RenameFolderRequest.class.getName());

    public RenameFolderRequest(String requestType, String username, String project, String projectFullName, String newName) {
        super(requestType, username, project, projectFullName, newName);
        this.newName = newName;
    }

    @Override
    public String getMessage() {
        return Messages.RenameFolderRequest_message(this.project, this.newName);
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    public boolean execute(Item item) {
        boolean success = false;
        try {
            if (Jenkins.get().hasPermission(Item.DELETE) && !Jenkins.get().hasPermission(Item.CREATE) && Jenkins.get().hasPermission(Item.CONFIGURE) || !Jenkins.get().hasPermission(Item.DELETE) && Jenkins.get().hasPermission(Item.CREATE) && Jenkins.get().hasPermission(Item.CONFIGURE) || Jenkins.get().hasPermission(Item.DELETE) && Jenkins.get().hasPermission(Item.CREATE) && Jenkins.get().hasPermission(Item.CONFIGURE)) {
                ((Folder)item).renameTo(this.newName);
                success = true;
                LOGGER.log(Level.INFO, "The Folder {0} has been properly renamed in {1}", new Object[]{item.getName(), this.newName});
            } else {
                this.errorMessage = "The current user " + this.username + " has no permission to RENAME the Folder";
                LOGGER.log(Level.FINE, "The current user {0} has no permission to RENAME the Folder", new Object[]{this.username});
            }
        }
        catch (Exception e) {
            this.errorMessage = "Unable to RENAME the Folder: " + e.getMessage().toString();
            LOGGER.log(Level.SEVERE, "Unable to RENAME the Folder " + item.getName(), e.getMessage().toString());
        }
        return success;
    }
}

