/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.model.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.model.Item;
import hudson.model.Job;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class DeleteJobRequest
extends Request {
    private static final Logger LOGGER = Logger.getLogger(DeleteJobRequest.class.getName());

    public DeleteJobRequest(String requestType, String username, String project, String projectFullName, String buildNumber) {
        super(requestType, username, project, projectFullName, buildNumber);
    }

    @Override
    public String getMessage() {
        return Messages.DeleteJobRequest_message(this.project);
    }

    public boolean execute_backup(Item item) {
        boolean success = false;
        try {
            if (Jenkins.get().hasPermission(Item.DELETE)) {
                try {
                    item.delete();
                    success = true;
                    this.errorMessage = "The Job " + item.getFullName() + " has been properly Deleted";
                    LOGGER.log(Level.INFO, "The job {0} has been properly deleted", item.getFullName());
                }
                catch (Exception e) {
                    this.errorMessage = e.getMessage().toString();
                    LOGGER.log(Level.SEVERE, "Unable to delete the job " + item.getFullName(), e);
                }
            } else {
                this.errorMessage = "The current user " + this.username + " does not have permission to delete the job";
                LOGGER.log(Level.FINE, "The current user {0} does not have permission to DELETE the job", new Object[]{this.username});
            }
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage().toString();
            LOGGER.log(Level.SEVERE, "Unable to Delete the job " + this.projectFullName + ":" + this.buildNumber, e.getMessage().toString());
            return false;
        }
        return success;
    }

    @Override
    public boolean execute(Item item) {
        boolean success = false;
        StringBuffer stringBuffer = new StringBuffer();
        String[] projectList = null;
        if (Jenkins.get().hasPermission(Job.DELETE)) {
            String returnStatus;
            String jenkinsURL = Jenkins.get().getRootUrl();
            if (jenkinsURL == null) {
                LOGGER.log(Level.SEVERE, "Jenkins instance is null: ");
                return false;
            }
            if (!this.projectFullName.contains("/job/") && this.projectFullName.contains("/")) {
                projectList = this.projectFullName.split("/");
                int nameCount = projectList.length;
                stringBuffer.append(projectList[0]);
                for (int i = 1; i < nameCount; ++i) {
                    stringBuffer.append("/job/");
                    stringBuffer.append(projectList[i]);
                }
                this.projectFullName = stringBuffer.toString();
            }
            RequestsUtility requestsUtility = new RequestsUtility();
            this.projectFullName = this.projectFullName.replace(" ", "%20");
            String urlString = jenkinsURL + "job/" + this.projectFullName + "/doDelete";
            LOGGER.info("[INFO] Delete Build urlString: " + urlString);
            try {
                returnStatus = requestsUtility.runPostMethod(jenkinsURL, urlString);
            }
            catch (IOException e) {
                this.errorMessage = e.getMessage();
                LOGGER.log(Level.SEVERE, "Unable to DELETE the Build " + this.projectFullName + ":" + this.buildNumber, e.getMessage().toString());
                return false;
            }
            if (returnStatus.equals("success")) {
                this.errorMessage = "Job : " + this.projectFullName + " has been properly Deleted";
                LOGGER.log(Level.INFO, "Job {0} has been properly Deleted", this.projectFullName);
                success = true;
            } else if (returnStatus.contains("Forbidden")) {
                this.errorMessage = "The current user " + this.username + " does not have permission to DELETE the Job";
                LOGGER.log(Level.SEVERE, "The current user {0} does not have permission to DELETE the Job", new Object[]{this.username});
                success = false;
            } else {
                this.errorMessage = "DELETE Job request has failed for " + this.projectFullName + " : " + returnStatus.toString();
                LOGGER.log(Level.INFO, "DELETE Job request has failed: ", this.projectFullName + " : " + returnStatus.toString());
                success = false;
            }
        } else {
            this.errorMessage = "The current user " + this.username + " does not have permission to DELETE the Job";
            LOGGER.log(Level.FINE, "The current user {0} does not have permission to DELETE the Job", new Object[]{this.username});
            success = false;
        }
        return success;
    }
}

