/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.model.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import hudson.model.Item;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class DeleteFolderRequest
extends Request {
    private static final Logger LOGGER = Logger.getLogger(DeleteFolderRequest.class.getName());

    public DeleteFolderRequest(String requestType, String username, String project, String projectFullName, String buildNumber) {
        super(requestType, username, project, projectFullName, buildNumber);
    }

    @Override
    public String getMessage() {
        return Messages.DeleteFolderRequest_message(this.project);
    }

    @Override
    public boolean execute(Item item) {
        boolean success = false;
        try {
            if (Jenkins.get().hasPermission(Item.DELETE)) {
                try {
                    item.delete();
                    success = true;
                    this.errorMessage = "The Folder " + item.getFullName() + " has been properly Deleted";
                    LOGGER.log(Level.INFO, "The Folder {0} has been properly deleted", item.getFullName());
                }
                catch (Exception e) {
                    this.errorMessage = e.getMessage().toString();
                    LOGGER.log(Level.SEVERE, "Unable to DELETE the Folder " + item.getFullName(), e);
                    success = false;
                }
            } else {
                this.errorMessage = "The current user " + this.username + " does not have permission to DELETE the Folder";
                LOGGER.log(Level.FINE, "The current user {0} does not have permission to DELETE the Folder", new Object[]{this.username});
                success = false;
            }
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage().toString();
            LOGGER.log(Level.SEVERE, "Unable to DELETE the Folder " + this.projectFullName + ":" + this.buildNumber, e.getMessage().toString());
            success = false;
        }
        return success;
    }
}

