/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.model.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.model.Item;
import hudson.security.Permission;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class DeleteBuildRequest
extends Request {
    private static final Logger LOGGER = Logger.getLogger(DeleteBuildRequest.class.getName());

    public DeleteBuildRequest(String requestType, String username, String project, String projectFullName, String buildNumber) {
        super(requestType, username, project, projectFullName, buildNumber);
    }

    @Override
    public String getMessage() {
        return Messages.DeleteBuildRequest_message(this.buildNumber + " for " + this.project);
    }

    @Override
    public boolean execute(Item item) {
        boolean success;
        block12: {
            success = false;
            try {
                Jenkins jenkins = Jenkins.get();
                LOGGER.info("[DEBUG] DeleteBuildRequest triggered - projectFullName: " + this.projectFullName);
                Permission permission = Item.DELETE;
                jenkins.getACL().checkPermission(permission);
                if (jenkins.hasPermission(permission)) {
                    String returnStatus;
                    String jenkinsURL = Jenkins.get().getRootUrl();
                    if (jenkinsURL == null) {
                        LOGGER.log(Level.SEVERE, "Jenkins instance is null: ");
                        return false;
                    }
                    RequestsUtility requestsUtility = new RequestsUtility();
                    this.projectFullName = this.projectFullName.replace(" ", "%20");
                    String urlString = jenkinsURL + "job/" + this.projectFullName + "/" + this.buildNumber + "/doDelete";
                    LOGGER.info("[INFO] Delete Build urlString: " + urlString);
                    try {
                        returnStatus = requestsUtility.runPostMethod(jenkinsURL, urlString);
                    }
                    catch (Exception e) {
                        this.errorMessage = e.getMessage().toString();
                        LOGGER.log(Level.SEVERE, "runPostMethod Error: Unable to Delete the build " + this.projectFullName + " : " + this.buildNumber + " : " + e.getMessage().toString());
                        return false;
                    }
                    if (returnStatus.equals("success")) {
                        this.errorMessage = "Build number " + this.buildNumber + " has been properly Deleted for " + this.projectFullName;
                        LOGGER.log(Level.INFO, "Build {0} has been properly Deleted", this.projectFullName + ":" + this.buildNumber);
                        success = true;
                    } else if (returnStatus.contains("Forbidden")) {
                        this.errorMessage = "The current user " + this.username + " does not have permission to DELETE the Build";
                        LOGGER.log(Level.SEVERE, "The current user {0} does not have permission to DELETE the Build", new Object[]{this.username});
                        success = false;
                    } else if (returnStatus.contains("Bad Request")) {
                        this.errorMessage = "The DELETE Build request has failed. The Build trying to be deleted may be locked.";
                        LOGGER.log(Level.SEVERE, "The Delete Build request has failed. The Build trying to be deleted may be locked. " + this.projectFullName + ":" + this.buildNumber);
                        success = false;
                    } else {
                        this.errorMessage = "DELETE Build request has failed for " + this.projectFullName + ":" + this.buildNumber + " : " + returnStatus;
                        LOGGER.log(Level.SEVERE, "DELETE Build request has failed: ", this.projectFullName + ":" + this.buildNumber + " : " + returnStatus);
                        success = false;
                    }
                    break block12;
                }
                this.errorMessage = "The current user " + this.username + " does not have permission to DELETE the Build";
                LOGGER.log(Level.FINE, "The current user {0} does not have permission to DELETE the Build", new Object[]{this.username});
            }
            catch (Exception e) {
                this.errorMessage = e.getMessage().toString();
                LOGGER.log(Level.SEVERE, "Jenkins.get Error: Unable to Delete the build " + this.projectFullName + " : " + this.buildNumber + " : " + e.getMessage().toString());
                success = false;
            }
        }
        return success;
    }
}

