/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.action;

import com.michelin.cio.jenkins.plugin.requests.RequestsPlugin;
import com.michelin.cio.jenkins.plugin.requests.action.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.RenameJobRequest;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.Permission;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class RequestRenameJobAction
implements Action {
    private Job<?, ?> project;
    private Job<?, ?> project2;
    private static final Logger LOGGER = Logger.getLogger(RequestRenameJobAction.class.getName());

    public RequestRenameJobAction(Job<?, ?> target) {
        this.project2 = (Job)target.getTarget();
        this.project = this.project2;
    }

    @POST
    public HttpResponse doCreateRenameJobRequest(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, MessagingException {
        try {
            if (this.isIconDisplayed()) {
                String newName = request.getParameter("new-name");
                String username = request.getParameter("username");
                RequestsPlugin plugin = (RequestsPlugin)Jenkins.get().getPlugin(RequestsPlugin.class);
                if (plugin == null) {
                    return null;
                }
                String projectName = this.project.getFullName();
                String projectFullName = this.project.getFullName();
                LOGGER.info("Rename Job Request Before: " + projectName + " - " + projectFullName);
                if (!projectFullName.contains("/job/") && projectFullName.contains("/")) {
                    RequestsUtility requestsUtility = new RequestsUtility();
                    projectFullName = requestsUtility.constructFolderJobName(projectFullName);
                }
                if (projectName.contains("/")) {
                    String[] projectnameList = projectName.split("/");
                    int nameCount = projectnameList.length;
                    projectName = projectnameList[nameCount - 1];
                }
                LOGGER.info("Rename Job Request After: " + projectName + " - " + projectFullName);
                String[] emailData = new String[]{projectName + " -> " + newName, username, "A Rename Job", this.project.getAbsoluteUrl()};
                plugin.addRequestPlusEmail(new RenameJobRequest("renameJob", username, projectName, projectFullName, newName), emailData);
                LOGGER.log(Level.INFO, "The request to rename the job {0} to {1} has been sent to the administrator", new Object[]{this.project.getName(), newName});
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + e.getMessage());
            return null;
        }
        return new HttpRedirect(request.getContextPath() + '/' + this.project.getUrl());
    }

    public String getDisplayName() {
        if (this.isIconDisplayed()) {
            return Messages.RequestRenameJobAction_DisplayName();
        }
        return null;
    }

    public String getIconFileName() {
        if (this.isIconDisplayed()) {
            return "/images/24x24/setting.png";
        }
        return null;
    }

    public Job<?, ?> getProject() {
        Job project2a = (Job)this.project2.getTarget();
        return project2a;
    }

    public String getUrlName() {
        return "request-rename-job";
    }

    private boolean isIconDisplayed() {
        boolean isDisplayed = false;
        try {
            isDisplayed = !this.hasDeletePermission() && !this.hasConfigurePermission() && this.hasCreatePermission() || !this.hasCreatePermission() && !this.hasConfigurePermission() && this.hasDeletePermission() || !this.hasDeletePermission() && !this.hasCreatePermission() && !this.hasConfigurePermission();
        }
        catch (IOException | ServletException e) {
            LOGGER.log(Level.WARNING, "Impossible to know if the icon has to be displayed", e);
        }
        return isDisplayed;
    }

    private boolean hasConfigurePermission() throws IOException, ServletException {
        return Functions.hasPermission(this.project, (Permission)Item.CONFIGURE);
    }

    private boolean hasCreatePermission() throws IOException, ServletException {
        return Functions.hasPermission(this.project, (Permission)Item.CREATE);
    }

    private boolean hasDeletePermission() throws IOException, ServletException {
        return Functions.hasPermission(this.project, (Permission)Item.DELETE);
    }
}

