/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.action;

import com.michelin.cio.jenkins.plugin.requests.RequestsPlugin;
import com.michelin.cio.jenkins.plugin.requests.action.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.DeleteJobRequest;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.Permission;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class RequestDeleteJobAction
implements Action {
    private Job<?, ?> project;
    private Job<?, ?> project2;
    private static final Logger LOGGER = Logger.getLogger(RequestDeleteJobAction.class.getName());

    public RequestDeleteJobAction(Job<?, ?> target) {
        this.project2 = (Job)target.getTarget();
        this.project = this.project2;
    }

    @POST
    public HttpResponse doCreateDeleteJobRequest(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, MessagingException {
        try {
            if (this.isIconDisplayed()) {
                String username = request.getParameter("username");
                RequestsPlugin plugin = (RequestsPlugin)Jenkins.get().getPlugin(RequestsPlugin.class);
                if (plugin == null) {
                    return null;
                }
                String projectName = this.project.getFullName();
                String projectFullName = this.project.getFullName();
                if (!projectFullName.contains("/job/") && projectFullName.contains("/")) {
                    RequestsUtility requestsUtility = new RequestsUtility();
                    projectFullName = requestsUtility.constructFolderJobName(projectFullName);
                }
                String[] emailData = new String[]{this.project.getName(), username, "A Delete Job", this.project.getAbsoluteUrl()};
                if (projectName.contains("/")) {
                    String[] projectnameList = projectName.split("/");
                    int nameCount = projectnameList.length;
                    projectName = projectnameList[nameCount - 1];
                }
                LOGGER.info("Delete Job Request: " + projectName + " - " + projectFullName);
                plugin.addRequestPlusEmail(new DeleteJobRequest("deleteJob", username, projectName, projectFullName, ""), emailData);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + e.getMessage());
            return null;
        }
        return new HttpRedirect(request.getContextPath() + '/' + this.project.getUrl());
    }

    public String getDisplayName() {
        if (this.isIconDisplayed()) {
            return Messages.RequestDeleteJobAction_DisplayName();
        }
        return null;
    }

    public String getIconFileName() {
        if (this.isIconDisplayed()) {
            return "/images/24x24/edit-delete.png";
        }
        return null;
    }

    public Job<?, ?> getProject() {
        Job project2a = (Job)this.project2.getTarget();
        return project2a;
    }

    public String getUrlName() {
        return "request-delete-job";
    }

    private boolean isIconDisplayed() {
        boolean isDisplayed = false;
        try {
            isDisplayed = !this.hasDeletePermission();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Impossible to know if the icon has to be displayed", e);
        }
        return isDisplayed;
    }

    private boolean hasDeletePermission() throws IOException, ServletException {
        return Functions.hasPermission(this.project, (Permission)Item.DELETE);
    }
}

