/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.action;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.FolderProperty;
import com.michelin.cio.jenkins.plugin.requests.RequestsPlugin;
import com.michelin.cio.jenkins.plugin.requests.action.Messages;
import com.michelin.cio.jenkins.plugin.requests.action.RequestMailSender;
import com.michelin.cio.jenkins.plugin.requests.model.DeleteFolderRequest;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Item;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class RequestDeleteFolderAction
extends FolderProperty<Folder>
implements Action {
    private Folder project;
    private Folder project2;
    private static final Logger LOGGER = Logger.getLogger(RequestDeleteFolderAction.class.getName());

    public RequestDeleteFolderAction(Folder target) {
        this.project = this.project2 = (Folder)target.getTarget();
    }

    @POST
    public HttpResponse doCreateDeleteFolderRequest(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, MessagingException {
        try {
            if (this.isIconDisplayed()) {
                String username = request.getParameter("username");
                RequestsPlugin plugin = (RequestsPlugin)Jenkins.get().getPlugin(RequestsPlugin.class);
                if (plugin == null) {
                    return null;
                }
                String projectName = this.project.getFullName();
                String projectFullName = this.project.getFullName();
                if (!projectFullName.contains("/job/") && projectFullName.contains("/")) {
                    RequestsUtility requestsUtility = new RequestsUtility();
                    projectFullName = requestsUtility.constructFolderJobName(projectFullName);
                }
                String[] emailData = new String[]{this.project.getName(), username, "A Delete Folder", this.project.getAbsoluteUrl()};
                if (projectName.contains("/")) {
                    String[] projectnameList = projectName.split("/");
                    int nameCount = projectnameList.length;
                    projectName = projectnameList[nameCount - 1];
                }
                LOGGER.info("Delete Folder Request: " + projectName + " - " + projectFullName);
                plugin.addRequestPlusEmail(new DeleteFolderRequest("deleteFolder", username, projectName, projectFullName, ""), emailData);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + e.getMessage());
            return null;
        }
        return new HttpRedirect(request.getContextPath() + '/' + this.project.getUrl());
    }

    public String getDisplayName() {
        if (this.isIconDisplayed()) {
            return Messages.RequestDeleteFolderAction_DisplayName();
        }
        return null;
    }

    public String getIconFileName() {
        if (this.isIconDisplayed()) {
            return "/images/24x24/setting.png";
        }
        return null;
    }

    public Folder getProject() {
        Folder project2a = (Folder)this.project2.getTarget();
        return project2a;
    }

    public String getUrlName() {
        return "request-delete-folder";
    }

    private boolean isIconDisplayed() {
        boolean isDisplayed = false;
        try {
            isDisplayed = !this.hasDeletePermission();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Impossible to know if the icon has to be displayed", e);
        }
        return isDisplayed;
    }

    private boolean hasDeletePermission() throws IOException, ServletException {
        return Functions.hasPermission((Object)this.project, (Permission)Item.DELETE);
    }

    @Extension
    public static class TransientFolderActionFactoryImpl
    extends TransientActionFactory<Folder> {
        public Collection<? extends Action> createFor(Folder target) {
            RequestMailSender.DescriptorEmailImpl descriptorEmailImpl = new RequestMailSender.DescriptorEmailImpl();
            ArrayList<RequestDeleteFolderAction> adminActions = new ArrayList<RequestDeleteFolderAction>();
            if (descriptorEmailImpl.isEnableDeleteFolder()) {
                adminActions.add(new RequestDeleteFolderAction(target));
            }
            return adminActions;
        }

        public Class<Folder> type() {
            return Folder.class;
        }
    }
}

