/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.action;

import com.michelin.cio.jenkins.plugin.requests.RequestsPlugin;
import com.michelin.cio.jenkins.plugin.requests.action.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.DeleteBuildRequest;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Run;
import hudson.security.Permission;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.POST;

public class RequestDeleteBuildAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(RequestDeleteBuildAction.class.getName());
    private String buildName;
    private int buildNumber;
    private String fullDisplayName;
    private String build_Url;

    public RequestDeleteBuildAction(Run<?, ?> target) {
        this.buildName = target.getDisplayName();
        this.buildNumber = target.getNumber();
        this.fullDisplayName = target.getFullDisplayName();
        this.build_Url = target.getUrl();
    }

    @POST
    public HttpResponse doCreateDeleteBuildRequest(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, MessagingException {
        if (this.isIconDisplayed()) {
            String username = request.getParameter("username");
            RequestsPlugin plugin = (RequestsPlugin)Jenkins.get().getPlugin(RequestsPlugin.class);
            if (plugin == null) {
                return null;
            }
            String projectFullName = "";
            String projectName = "";
            StringBuffer stringBuffer = new StringBuffer();
            LOGGER.info("Delete Build Action: fullDisplayName " + this.fullDisplayName);
            if (this.fullDisplayName.contains(" \u00bb ")) {
                String[] Folder_project_BuildList = null;
                Folder_project_BuildList = this.fullDisplayName.split(" \u00bb ");
                int folderCount = Folder_project_BuildList.length;
                for (int i = 0; i < folderCount - 1; ++i) {
                    stringBuffer.append(Folder_project_BuildList[i] + "/job/");
                }
                projectName = Folder_project_BuildList[folderCount - 1].split(" #")[0];
                stringBuffer.append(projectName);
                projectFullName = stringBuffer.toString();
            } else {
                if (this.fullDisplayName.contains(" #")) {
                    projectFullName = this.fullDisplayName.split(" #")[0];
                } else if (this.fullDisplayName.contains(" ")) {
                    projectFullName = this.fullDisplayName.split(" ")[0];
                }
                projectName = projectFullName;
            }
            String jenkinsUrl = Jenkins.get().getRootUrl();
            String buildUrl = jenkinsUrl + this.build_Url;
            String[] emailData = new String[]{this.buildName, username, "A Delete Build", buildUrl};
            LOGGER.info("[DEBUG] Delete Build Action: " + projectName + " : " + projectFullName);
            plugin.addRequestPlusEmail(new DeleteBuildRequest("deleteBuild", username, projectName, projectFullName, Integer.toString(this.buildNumber)), emailData);
        }
        return new HttpRedirect(request.getContextPath() + '/' + this.build_Url);
    }

    public String getDisplayName() {
        if (this.isIconDisplayed()) {
            return Messages.RequestDeleteBuildAction_DisplayName();
        }
        return null;
    }

    public String getIconFileName() {
        if (this.isIconDisplayed()) {
            return "/images/24x24/edit-delete.png";
        }
        return null;
    }

    public String getUrlName() {
        return "request-delete-build";
    }

    private boolean isIconDisplayed() {
        boolean isDisplayed = false;
        try {
            isDisplayed = !this.hasDeletePermission();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Impossible to know if the icon has to be displayed", e);
        }
        return isDisplayed;
    }

    private boolean hasDeletePermission() throws IOException, ServletException {
        return Functions.hasPermission((Permission)Run.DELETE);
    }
}

